% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.r
\name{Queue}
\alias{Queue}
\title{Assigns Jobs to a Set of Workers}
\description{
Jobs go in. Results come out.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{hooks}}{A named list of currently registered callback hooks.}

\item{\code{jobs}}{Get or set - List of \link[=Job]{Jobs} currently managed by this Queue.}

\item{\code{state}}{The Queue's state: \code{'starting'}, \code{'idle'}, \code{'busy'}, \code{'stopped'}, or \code{'error.'}}

\item{\code{uid}}{Get or set - Unique identifier, e.g. \code{'Q1'}.}

\item{\code{tmp}}{The Queue's temporary directory.}

\item{\code{workers}}{Get or set - List of \link[=Worker]{Workers} used for processing Jobs.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Queue-new}{\code{Queue$new()}}
\item \href{#method-Queue-print}{\code{Queue$print()}}
\item \href{#method-Queue-run}{\code{Queue$run()}}
\item \href{#method-Queue-submit}{\code{Queue$submit()}}
\item \href{#method-Queue-wait}{\code{Queue$wait()}}
\item \href{#method-Queue-on}{\code{Queue$on()}}
\item \href{#method-Queue-stop}{\code{Queue$stop()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-new"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-new}{}}}
\subsection{Method \code{new()}}{
Creates a pool of background processes for handling \verb{$run()} and
\verb{$submit()} calls. These workers are initialized according to the
\code{globals}, \code{packages}, and \code{init} arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$new(
  globals = NULL,
  packages = NULL,
  init = NULL,
  max_cpus = parallelly::availableCores(),
  workers = ceiling(max_cpus * 1.2),
  timeout = NULL,
  hooks = NULL,
  reformat = NULL,
  signal = FALSE,
  cpus = 1L,
  stop_id = NULL,
  copy_id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{globals}}{A named list of variables that all \verb{<Job>$expr}s will have
access to. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.}

\item{\code{packages}}{Character vector of package names to load on workers.}

\item{\code{init}}{A call or R expression wrapped in curly braces to evaluate on
each worker just once, immediately after start-up. Will have access
to variables defined by \code{globals} and assets from \code{packages}.
Returned value is ignored.}

\item{\code{max_cpus}}{Total number of CPU cores that can be reserved by all
running Jobs (\verb{sum(<Job>$cpus)}). Does not enforce limits on actual
CPU utilization.}

\item{\code{workers}}{How many background \link{Worker} processes to start. Set to more
than \code{max_cpus} to enable standby Workers to quickly swap out with
Workers that need to restart.}

\item{\code{timeout, hooks, reformat, signal, cpus, stop_id, copy_id}}{Defaults for this Queue's \verb{$run()} method. Here only, \code{stop_id}
and \code{copy_id} must be either a \verb{function (job)} or \code{NULL}.
\code{hooks} can set queue, worker, and/or job hooks - see the
"Attaching" section in \code{vignette('hooks')}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Queue} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-print"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-print}{}}}
\subsection{Method \code{print()}}{
Print method for a \code{Queue}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments are not used currently.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-run"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-run}{}}}
\subsection{Method \code{run()}}{
Creates a Job object and submits it to the queue for running.
Any \code{NA} arguments will be replaced with their value from \code{Queue$new()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$run(
  expr,
  vars = list(),
  timeout = NA,
  hooks = NA,
  reformat = NA,
  signal = NA,
  cpus = NA,
  stop_id = NA,
  copy_id = NA,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{A call or R expression wrapped in curly braces to evaluate on a
worker. Will have access to any variables defined by \code{vars}, as well
as the Worker's \code{globals}, \code{packages}, and \code{init} configuration.
See \code{vignette('eval')}.}

\item{\code{vars}}{A named list of variables to make available to \code{expr} during
evaluation. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.}

\item{\code{timeout}}{A named numeric vector indicating the maximum number of
seconds allowed for each state the job passes through, or 'total' to
apply a single timeout from 'submitted' to 'done'. Example:
\code{timeout = c(total = 2.5, running = 1)}. See \code{vignette('stops')}.}

\item{\code{hooks}}{A named list of functions to run when the Job state changes,
of the form \code{hooks = list(created = function (worker) {...})}.
Names of worker hooks are typically \code{'created'}, \code{'submitted'},
\code{'queued'}, \code{'dispatched'}, \code{'starting'}, \code{'running'}, \code{'done'}, or
\code{'*'} (duplicates okay). See \code{vignette('hooks')}.}

\item{\code{reformat}}{Set \verb{reformat = function (job)} to define what
\verb{<Job>$result} should return. The default, \code{reformat = NULL} passes
\verb{<Job>$output} to \verb{<Job>$result} unchanged.
See \code{vignette('results')}.}

\item{\code{signal}}{Should calling \verb{<Job>$result} signal on condition objects?
When \code{FALSE}, \verb{<Job>$result} will return the object without
taking additional action. Setting to \code{TRUE} or a character vector of
condition classes, e.g. \code{c('interrupt', 'error', 'warning')}, will
cause the equivalent of \verb{stop(<condition>)} to be called when those
conditions are produced. See \code{vignette('results')}.}

\item{\code{cpus}}{How many CPU cores to reserve for this Job. Used to limit the
number of Jobs running simultaneously to respect \verb{<Queue>$max_cpus}.
Does not prevent a Job from using more CPUs than reserved.}

\item{\code{stop_id}}{If an existing \link{Job} in the Queue has the same \code{stop_id},
that Job will be stopped and return an 'interrupt' condition object
as its result. \code{stop_id} can also be a \verb{function (job)} that returns
the \code{stop_id} to assign to a given Job. A \code{stop_id} of \code{NULL}
disables this feature. See \code{vignette('stops')}.}

\item{\code{copy_id}}{If an existing \link{Job} in the Queue has the same \code{copy_id},
the newly submitted Job will become a "proxy" for that earlier Job,
returning whatever result the earlier Job returns. \code{copy_id} can also
be a \verb{function (job)} that returns the \code{copy_id} to assign to a given
Job. A \code{copy_id} of \code{NULL} disables this feature.
See \code{vignette('stops')}.}

\item{\code{...}}{Arbitrary named values to add to the returned Job object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The new \link{Job} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-submit"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-submit}{}}}
\subsection{Method \code{submit()}}{
Adds a Job to the Queue for running on a background process.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$submit(job)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job}}{A \link{Job} object, as created by \code{Job$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This Queue, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-wait"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-wait}{}}}
\subsection{Method \code{wait()}}{
Blocks until the Queue enters the given state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$wait(state = "idle")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a Queue state. Typically one of:
\itemize{
\item \code{'*'} -        Every time the state changes.
\item \code{'.next'} -    Only one time, the next time the state changes.
\item \code{'starting'} - Workers are starting.
\item \code{'idle'} -     All workers are ready/idle.
\item \code{'busy'} -     At least one worker is busy.
\item \code{'stopped'} -  Shutdown is complete.
\item \code{'error'} -    Workers did not start cleanly.
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This Queue, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-on"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-on}{}}}
\subsection{Method \code{on()}}{
Attach a callback function to execute when the Queue enters \code{state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$on(state, func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{The name of a Queue state. Typically one of:
\itemize{
\item \code{'*'} -        Every time the state changes.
\item \code{'.next'} -    Only one time, the next time the state changes.
\item \code{'starting'} - Workers are starting.
\item \code{'idle'} -     All workers are ready/idle.
\item \code{'busy'} -     At least one worker is busy.
\item \code{'stopped'} -  Shutdown is complete.
\item \code{'error'} -    Workers did not start cleanly.
}}

\item{\code{func}}{A function that accepts a Queue object as input. Return value
is ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A function that when called removes this callback from the Queue.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Queue-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Queue-stop}{}}}
\subsection{Method \code{stop()}}{
Stop all jobs and workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Queue$stop(reason = "job queue shut down by user", cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reason}}{Passed to \verb{<Job>$stop()} for any Jobs currently managed by
this Queue.}

\item{\code{cls}}{Passed to \verb{<Job>$stop()} for any Jobs currently managed by
this Queue.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This Queue, invisibly.
}
}
}
