% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{regressogram}
\alias{regressogram}
\title{Plot Sample Regressograms and Fitted Curves}
\usage{
regressogram(object, time)
}
\arguments{
\item{object}{a fitted joint mean covariance model of class "jmcmMod", i.e.,
typically the result of jmcm().}

\item{time}{a vector of obeservation time points}
}
\description{
Plot the sample regressograms based on the sample covariance
matrix and superimpose the corresponding fitted curves to check the model
fitting when the longitudinal dataset is balanced.
}
\examples{
cattleA <- cattle[cattle$group=='A', ]
fit.mcd <- jmcm(weight | id | I(ceiling(day/14 + 1)) ~ 1 | 1, data=cattleA,
  triple = c(8, 3, 4), cov.method = 'mcd')
regressogram(fit.mcd, time = 1:11)

}

