##' @useDynLib jiebaR
##' @import Rcpp
##' @import methods
NULL 

#' The path of dictionary
#' 
#' The path of dictionary, and it is used by segmentation and other 
#' function. 
#' @format  character
#' @export
DICTPATH<-NULL

#' @rdname DICTPATH
#' @export
HMMPATH<-NULL

#' @rdname DICTPATH
#' @export
USERPATH<-NULL

#' @rdname DICTPATH
#' @export
IDFPATH<-NULL

#' @rdname DICTPATH
#' @export
STOPPATH<-NULL

.onLoad <- function(libname, pkgname) {
#     if (.Platform$OS.type == "windows") {
#       Sys.setlocale( locale = "English")
#     }
  
    assign(x = "DICTPATH", file.path(find.package("jiebaR"),"dict","jieba.dict.utf8"),asNamespace('jiebaR'))
    assign(x = "HMMPATH",  file.path(find.package("jiebaR"),"dict","hmm_model.utf8"),asNamespace('jiebaR'))
    assign(x = "USERPATH", file.path(find.package("jiebaR"),"dict","user.dict.utf8"),asNamespace('jiebaR'))
    assign(x = "STOPPATH", file.path(find.package("jiebaR"),"dict","stop_words.utf8"),asNamespace('jiebaR'))
    assign(x = "IDFPATH",  file.path(find.package("jiebaR"),"dict","idf.utf8"),asNamespace('jiebaR'))

}

setLoadAction(
  function(ns){ 
    loadModule("mod_mpseg", TRUE)
    loadModule("mod_mixseg", TRUE)
    loadModule("mod_query", TRUE)
    loadModule("mod_hmmseg", TRUE)
    loadModule("mod_tag", TRUE)
    loadModule("mod_key", TRUE)
    loadModule("mod_sim", TRUE)
    ###Loading DICTPATH when package loaded.

   })
