% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wzeta.R
\name{wzeta}
\alias{wzeta}
\title{Weierstrass zeta function}
\usage{
wzeta(z, g = NULL, omega = NULL, tau = NULL)
}
\arguments{
\item{z}{complex number, vector or matrix}

\item{g}{the elliptic invariants, a vector of two complex numbers; only 
one of \code{g}, \code{omega} and \code{tau} must be given}

\item{omega}{the half-periods, a vector of two complex numbers; only 
one of \code{g}, \code{omega} and \code{tau} must be given}

\item{tau}{the half-periods ratio; supplying \code{tau} is equivalent to 
supply \code{omega = c(1/2, tau/2)}}
}
\value{
A complex number, vector or matrix.
}
\description{
Evaluation of the Weierstrass zeta function.
}
\examples{
# Mirror symmetry property:
z <- 1 + 1i
g <- c(1i, 1+2i)
wzeta(Conj(z), Conj(g))
Conj(wzeta(z, g))
}
