% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{iv_align}
\alias{iv_align}
\title{Align after locating relationships}
\usage{
iv_align(needles, haystack, ..., locations)
}
\arguments{
\item{needles, haystack}{\verb{[vector]}

Two vectors to align.}

\item{...}{These dots are for future extensions and must be empty.}

\item{locations}{\verb{[two-column data frame]}

The data frame of locations returned from one of \code{\link[=iv_locate_overlaps]{iv_locate_overlaps()}},
\code{\link[=iv_locate_precedes]{iv_locate_precedes()}}, \code{\link[=iv_locate_follows]{iv_locate_follows()}}, \code{\link[=iv_locate_relates]{iv_locate_relates()}}, or
\code{\link[=iv_locate_between]{iv_locate_between()}}.}
}
\value{
A two column data frame with a \verb{$needles} column containing the
sliced version of \code{needles} and a \verb{$haystack} column containing the sliced
version of \code{haystack}.
}
\description{
\code{iv_align()} will align/join \code{needles} and \code{haystack} together using a data
frame of \code{locations}. These \code{locations} are intended to be the output of one
of: \code{\link[=iv_locate_overlaps]{iv_locate_overlaps()}}, \code{\link[=iv_locate_precedes]{iv_locate_precedes()}}, \code{\link[=iv_locate_follows]{iv_locate_follows()}},
\code{\link[=iv_locate_relates]{iv_locate_relates()}}, or \code{\link[=iv_locate_between]{iv_locate_between()}}.

This is mainly a convenience function that slices both \code{needles} and
\code{haystack} according to those \code{locations}, and then stores the result
in a new two column data frame.
}
\examples{
needles <- iv_pairs(c(1, 5), c(3, 7), c(10, 12))
haystack <- iv_pairs(c(0, 2), c(4, 6))

locations <- iv_locate_overlaps(needles, haystack)
iv_align(needles, haystack, locations = locations)

locations <- iv_locate_overlaps(needles, haystack, no_match = "drop")
iv_align(needles, haystack, locations = locations)

needles <- c(1, 15, 4, 11)
haystack <- iv_pairs(c(1, 5), c(3, 7), c(10, 12))

locations <- iv_locate_between(needles, haystack)
iv_align(needles, haystack, locations = locations)
}
