% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv.R
\name{iv-genericity}
\alias{iv-genericity}
\alias{iv_proxy}
\alias{iv_restore}
\title{Proxy and restore}
\usage{
iv_proxy(x, ...)

iv_restore(x, to, ...)
}
\arguments{
\item{x}{\verb{[vector]}

A vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{to}{\verb{[vector]}

The original vector to restore to.}
}
\value{
\itemize{
\item \code{iv_proxy()} should return an iv object for further manipulation.
\item \code{iv_restore()} should return an object of type \code{to}, if possible. In
some cases, it may be required to fall back to returning an iv object.
}
}
\description{
\itemize{
\item \code{iv_proxy()} is an S3 generic which allows you to write S3 methods for
iv extension types to ensure that they are treated like iv objects. The
input will be your iv extension object, \code{x}, and the return value should
be an iv object.
\item \code{iv_restore()} is an S3 generic that dispatches off \code{to} that allows you
to restore a proxied iv extension type back to its original type. The
inputs will be a bare iv object, \code{x}, and your original iv extension
object, \code{to}, and the return value should correspond to \code{x} restored to
the type of \code{to}, if possible.
}

You typically \emph{don't} need to create an \code{iv_proxy()} method if your class
directly extends iv through the \code{class} argument of \code{\link[=new_iv]{new_iv()}}. You only
need to implement this if your class has a different structure than a
typical iv object. In particular, if \code{vctrs::field(x, "start")} and
\code{vctrs::field(x, "end")} don't return the \code{start} and \code{end} of the interval
vector respectively, then you probably need an \code{iv_proxy()} method.

You typically \emph{do} need an \code{iv_restore()} method for custom iv extensions.
If your class is simple, then you can generally just call your constructor,
like \code{new_my_iv()}, to restore the class and any additional attributes that
might be required.

This system allows you to use any \verb{iv_*()} function on your iv extension
object without having to define S3 methods for all of them.
}
\examples{
if (FALSE) {
# Registering S3 methods outside of a package doesn't always work quite
# right (like on the pkgdown site), so this code should only be run by a
# user reading the manual. If that is you, fear not! It should run just fine
# in your console.

library(vctrs)

new_nested_iv <- function(iv) {
  fields <- list(iv = iv)
  new_rcrd(fields, class = "nested_iv")
}

format.nested_iv <- function(x, ...) {
  format(field(x, "iv"))
}

iv_proxy.nested_iv <- function(x, ...) {
  field(x, "iv")
}

iv_restore.nested_iv <- function(x, to, ...) {
  new_nested_iv(x)
}

iv <- new_iv(c(1, 5), c(2, 7))

x <- new_nested_iv(iv)
x

# Proxies, then accesses the `start` field
iv_start(x)

# Proxies, computes the complement to generate an iv,
# then restores to the original type
iv_complement(x)

}
}
