% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivreg.fit.R
\name{ivreg.fit}
\alias{ivreg.fit}
\title{Fitting Instrumental-Variable Regressions by 2SLS}
\usage{
ivreg.fit(x, y, z, weights, offset, ...)
}
\arguments{
\item{x}{regressor matrix.}

\item{y}{vector for the response variable.}

\item{z}{instruments matrix.}

\item{weights}{an optional vector of weights to be used in the fitting
process.}

\item{offset}{an optional offset that can be used to specify an a priori
known component to be included during fitting.}

\item{\dots}{further arguments passed to \code{\link[stats:lmfit]{lm.fit}}
or \code{\link[stats:lmfit]{lm.wfit}}, respectively.}
}
\value{
\code{ivreg.fit} returns an unclassed list with the following
components: 
\item{coefficients}{parameter estimates, from the stage-2 regression.} 
\item{residuals}{vector of model residuals.} 
\item{residuals1}{matrix of residuals from the stage-1 regression.}
\item{residuals2}{vector of residuals from the stage-2 regression.}
\item{fitted.values}{vector of predicted means for the response.}
\item{weights}{either the vector of weights used (if any) or \code{NULL} (if none).} 
\item{offset}{either the offset used (if any) or \code{NULL} (if none).} 
\item{estfun}{a matrix containing the empirical estimating functions.} 
\item{n}{number of observations.} 
\item{nobs}{number of observations with non-zero weights.} 
\item{p}{number of columns in the model matrix x of regressors.}
\item{q}{number of columns in the instrumental variables model matrix z}
\item{rank}{numeric rank of the model matrix for the stage-2 regression.} 
\item{df.residual}{residual degrees of freedom for fitted model.} 
\item{cov.unscaled}{unscaled covariance matrix for the coefficients.} 
\item{sigma}{residual standard error.}
\item{x}{projection of x matrix onto span of z.}
\item{qr}{QR decomposition for the stage-2 regression.}
\item{qr1}{QR decomposition for the stage-1 regression.}
\item{rank1}{numeric rank of the model matrix for the stage-1 regression.}
\item{coefficients1}{matrix of coefficients from the stage-1 regression.}
}
\description{
Fit instrumental-variable regression by two-stage least squares (2SLS). This is
equivalent to direct instrumental-variables estimation when the number of
instruments is equal to the number of predictors.
}
\details{
\code{\link{ivreg}} is the high-level interface to the work-horse function
\code{ivreg.fit}. \code{ivreg.fit} is essentially a convenience interface to
\code{\link[stats:lmfit]{lm.fit}} (or \code{\link[stats:lmfit]{lm.wfit}})
for first projecting \code{x} onto the image of
\code{z}, then running a regression of \code{y} on the projected
\code{x}, and computing the residual standard deviation.
}
\examples{
## data
data("CigaretteDemand", package = "ivreg")

## high-level interface
m <- ivreg(log(packs) ~ log(rprice) + log(rincome) | salestax + log(rincome),
  data = CigaretteDemand)

## low-level interface
y <- m$y
x <- model.matrix(m, component = "regressors")
z <- model.matrix(m, component = "instruments")
ivreg.fit(x, y, z)$coefficients

}
\seealso{
\code{\link{ivreg}}, \code{\link[stats:lmfit]{lm.fit}}, \code{\link[stats:lmfit]{lm.wfit}}
}
\keyword{regression}
