% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wweights.R
\name{wlate1}
\alias{wlate1}
\title{Target weight for LATE}
\usage{
wlate1(data, from, to, Z, model, X, eval.X)
}
\arguments{
\item{data}{\code{data.frame} on which the estimation is performed.}

\item{from}{Vector of baseline values for the instruments.}

\item{to}{Vector of comparison values for the instruments.}

\item{Z}{Character vector of names of instruments.}

\item{model}{A \code{lm} or \code{glm} object, or a
\code{data.frame}, which can be used to estimate the propensity
to take up treatment for the specified values of the
instruments.}

\item{X}{Character vector of variable names for the non-excluded
variables the user wishes to condition the LATE on.}

\item{eval.X}{Vector of values the user wishes to condition the
\code{X} variables on.}
}
\value{
The bounds of integration over unobservable \code{u}, as
    well as the multiplier in the weight.
}
\description{
Function generates the target weight for the LATE, conditioned on a
specific value of the covariates.
}
