% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{genSSet}
\alias{genSSet}
\title{Generating LP moments for IV-like estimands}
\usage{
genSSet(data, sset, sest, splinesobj, pmodobj, pm0, pm1, ncomponents,
  scount, subset_index, means = TRUE, yvar, dvar, noisy = TRUE,
  ivn = NULL, redundant = NULL)
}
\arguments{
\item{data}{\code{data.frame} used to estimate the treatment
effects.}

\item{sset}{list, which is modified and returned as the
output. This object will contain all the information from the
IV-like specifications that can be used for estimating the
treatment effect.}

\item{sest}{list containing the point estimates and S-weights
corresponding to a particular IV-like estimand.}

\item{splinesobj}{list of spline components in the MTRs for treated
and control groups. Spline terms are extracted using
\code{\link{removeSplines}}.}

\item{pmodobj}{vector of propensity scores.}

\item{pm0}{list of the monomials in the MTR for the control group.}

\item{pm1}{list of the monomials in the MTR for the treated group.}

\item{ncomponents}{The number of components from the IV regression
to include in the S-set.}

\item{scount}{integer, an index for the elements in the S-set.}

\item{subset_index}{vector of integers, a row index for the subset of
the data the IV regression is restricted to.}

\item{means}{boolean, set to \code{TRUE} by default. If set to
\code{TRUE}, then the gamma moments are returned, i.e. sample
averages are taken. If set to \code{FALSE}, then no sample
averages are taken, and a matrix is returned. The sample
average of each column of the matrix corresponds to a
particular gamma moment.}

\item{yvar}{name of outcome variable. This is only used if
\code{means = FALSE}, which occurs when the user believes the
treatment effect is point identified.}

\item{dvar}{name of treatment indicator. This is only used if
\code{means = FALSE}, which occurs when the user believes the
treatment effect is point identified.}

\item{noisy}{boolean, default set to \code{TRUE}. If \code{TRUE},
then messages are provided throughout the estimation
procedure. Set to \code{FALSE} to suppress all messages,
e.g. when performing the bootstrap.}

\item{ivn}{integer, the number indicating which IV specification
the component corresponds to.}

\item{redundant}{vector of integers indicating which components in
the S-set are redundant.}
}
\value{
A list containing the point estimate for the IV regression,
    and the expectation of each monomial term in the MTR.
}
\description{
This function takes in the IV estimate and its IV-like
specification, and generates a list containing the corresponding
point estimate, and the corresponding moments (gammas) that will
enter into the constraint matrix of the LP problem. The function
requires the user to provide a list (i.e. the list the point
estimates and moments corresponding to other IV-like
specifications; or an empty list) to append these point estimates
and moments to.
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declare empty list to be updated (in the event multiple IV like
## specifications are provided)
sSet <- list()

## Declare MTR formulas
formula1 = ~ 1 + u
formula0 = ~ 1 + u

## Construct object that separates out non-spline components of MTR
## formulas from the spline components. The MTR functions are
## obtained from this object by the function 'genSSet'.
splinesList = list(removeSplines(formula0), removeSplines(formula1))

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

polynomials1 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

## Generate propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Generate IV estimates
ivEstimates <- ivEstimate(formula = ey ~ d | z,
                          data = dtm,
                          components = l(d),
                          treat = d,
                          list = FALSE)

## Construct S-set, which contains the coefficients and weights
## corresponding to various IV-like estimands
genSSet(data = dtm,
        sset = sSet,
        sest = ivEstimates,
        splinesobj = splinesList,
        pmodobj = propensityObj$phat,
        pm0 = polynomials0,
        pm1 = polynomials1,
        ncomponents = 1,
        scount = 1)

}
