% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testfunctions_splines.R
\name{genGammaSplinesTT}
\alias{genGammaSplinesTT}
\title{Generating the Gamma moments for splines, for 'testthat'}
\usage{
genGammaSplinesTT(distr, weight, zvars, u1s1, u0s1, u0s2, target = FALSE,
  ...)
}
\arguments{
\item{distr}{data.frame, the distribution of the data.}

\item{weight}{function, the S-function corresponding to a
particular IV-like estimand.}

\item{zvars}{vector, string names of the covariates, other than the
intercept and treatment variable.}

\item{u1s1}{matrix, the spline basis for the treated group ("u1")
corresponding to the first (and only) spline specification
("s1").}

\item{u0s1}{matrix, the spline basis for the control group ("u0")
corresponding to the first spline specification ("s1").}

\item{u0s2}{matrix, the spline basis for the control group ("u0")
corresponding to the second spline specification ("s2").}

\item{target}{boolean, set to \code{TRUE} if the gamma moment being
generated corresponds to the target parameter.}

\item{...}{all other arguments that enter into \code{weight},
excluding the argument \code{d} for treatment indicator.}
}
\value{
vector, the Gamma moments associated with \code{weight}.
}
\description{
This function generates the Gamma moments for a given set of
weights. This funciton is written specifically for tests.
}
