% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtr.R
\name{genBasisSplines}
\alias{genBasisSplines}
\title{Generate basis matrix for splines}
\usage{
genBasisSplines(splines, x, d = NULL)
}
\arguments{
\item{splines}{a list. The name of each element should be the
spline command, and each element should be a vector. Each entry
of the vector is a covariate that the spline should be
interacted with. Such an object can be generated by
\code{\link{removeSplines}}, and accessed using
\code{$splineslist}.}

\item{x}{the values of the unobservable at which the splines basis
should be evaluated.}

\item{d}{either 0 or 1, indicating the treatment status.}
}
\value{
a matrix. The number of rows is equal to the length of
    \code{x}, and the number of columns depends on the
    specifications of the spline. The name of each column takes the
    following form: "u[d]S[j].[b]", where "u" and "S" are fixed and
    stand for "unobservable" and "Splines" respectively. "[d]" will
    be either 0 or 1, depending on the treatment status. "[j]" will
    be an integer indicating which element of the list
    \code{splines} the column pertains to. "[b]" will be an integer
    reflect which component of the basis the column pertains to.
}
\description{
The user can declare that the unobservable enters into the MTRs in
the form of splines. This function generates the basis matrix for
the splines. The specifications for the spline must be passed as
the \code{$splineslist} object generated by
\code{\link{removeSplines}}. Note that this function does not
account for any interactions between the splines and the
covariates. Interactions can be added simply by sweeping the basis
matrix by a vector for the values of the covariates.
}
