% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{xptr_eval}
\alias{xptr_eval}
\title{Call a C++ function using an external pointer}
\usage{
xptr_eval(x, pars, xpsexp)
}
\arguments{
\item{x}{The main argument of the function.}

\item{pars}{A list of additional arguments to the function.  This may be an
empty list.}

\item{xpsexp}{An external pointer to a C++ function.}
}
\value{
A numeric scalar: the value of the C++ function evaluated at the
  input values \code{x} and \code{pars}.
}
\description{
This function is used in \code{\link{plot.itp}} to plot a function and
the root estimated by \code{\link{itp}}.
}
\details{
See the
\href{https://gallery.rcpp.org/articles/passing-cpp-function-pointers/}{
Passing user-supplied C++ functions} article in the
\href{https://gallery.rcpp.org/}{Rcpp Gallery} for information.
}
\examples{
lambert_ptr <- xptr_create("lambert")
res <- itp(lambert_ptr, c(-1, 1))

# Value at lower limit
xptr_eval(-1, list(), lambert_ptr)

# Value at upper limit
xptr_eval(1, list(), lambert_ptr)

# Value at the estimated root
xptr_eval(res$root, list(), lambert_ptr)
}
\seealso{
\code{\link{xptr_create}} for creating an external pointer to a
  C++ function.
}
