% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_model.R
\name{run_isobxr}
\alias{run_isobxr}
\title{Run isobxr stable isotope box model}
\usage{
run_isobxr(
  workdir,
  SERIES_ID,
  flux_list_name,
  coeff_list_name,
  t_lim,
  nb_steps,
  time_units,
  FORCING_RAYLEIGH = NULL,
  FORCING_SIZE = NULL,
  FORCING_DELTA = NULL,
  FORCING_ALPHA = NULL,
  COMPOSITE = FALSE,
  COMPO_SERIES_n = NaN,
  COMPO_SERIES_FAMILY = NaN,
  EXPLORER = FALSE,
  EXPLO_SERIES_n = NaN,
  EXPLO_SERIES_FAMILY = NaN,
  HIDE_PRINTS = FALSE,
  to_DIGEST_DIAGRAMS = TRUE,
  to_DIGEST_evD_PLOT = TRUE,
  to_DIGEST_CSV_XLS = FALSE,
  evD_PLOT_time_as_log = TRUE,
  plot_results = TRUE,
  save_run_outputs = FALSE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{0_ISOBXR_MASTER.xlsx}} master file \cr
and where output files will be stored if exported by user. \cr
(character string)}

\item{SERIES_ID}{Name of the model series the run belongs to. \cr
It determines the folder in which the output files will be stored.\cr
(character string)}

\item{flux_list_name}{Name of the list of fluxes and initial box sizes to be used for the run, \cr
calling (by its header name) a single column of the \strong{FLUXES} sheet
of the \strong{\emph{0_ISOBXR_MASTER.xlsx}} file. \cr
(character string)}

\item{coeff_list_name}{Name of the list of fractionation coefficients to be used for the run, \cr
calling (by its header name) a single column of the \strong{COEFFS} sheet
of the \strong{\emph{0_ISOBXR_MASTER.xlsx}} file. \cr
(character string)}

\item{t_lim}{Run duration, given in the same time units as the fluxes. \cr
(integer)}

\item{nb_steps}{Number of calculation steps. \cr
It determines the resolution of the run. \cr
(integer)}

\item{time_units}{Vector defining the initial time unit
(identical to unit used in fluxes), \cr
followed by the time unit used for the graphical output.\cr
Character string, to be selected  among the following:\cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr}\cr
e.g.,  c("d", "yr") to convert days into years}

\item{FORCING_RAYLEIGH}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on a fractionation coefficient
by a Rayleigh isotope distillation, \cr
as a function of flux intensities and a fundamental fractionation coefficient. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{FORCING_SIZE}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on one or several box sizes (mass of element X). \cr
The newly defined sizes for the given set of boxes
overwrite their sizes as previously defined in \strong{\emph{0_ISOBXR_MASTER.xlsx}} file. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{FORCING_DELTA}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on one or several boxes
initial isotope composition expressed as delta values. \cr
The newly defined delta values for the given set of boxes
overwrite the delta values as previously defined in \strong{\emph{0_ISOBXR_MASTER.xlsx}} file. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{FORCING_ALPHA}{\emph{OPTIONAL} \cr
Dataframe describing the forcing on one or several
fractionation coefficients from one reservoir to another. \cr
The newly defined alpha values for the given set of boxes
overwrite the alpha values as previously defined in \strong{\emph{0_ISOBXR_MASTER.xlsx}} file. \cr
Dataframe formatting details are in isobxr vignette. \cr
Default is NULL.}

\item{COMPOSITE}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Logical value automatically defined in \code{\link{compose_isobxr}}. \cr
Default is FALSE.}

\item{COMPO_SERIES_n}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Iteration of the composite run for the given series it belongs to,
automatically defined in \code{\link{compose_isobxr}}.  \cr
Default is NaN.}

\item{COMPO_SERIES_FAMILY}{\emph{NOT TO BE USED IN SINGLE RUN} \cr
Composite run series family, automatically defined in
\code{\link{compose_isobxr}}. \cr
Default is NaN.}

\item{EXPLORER}{\emph{NOT TO BE USED IN SINGLE RUN} \cr
Logical value automatically defined in \code{\link{sweep_steady}}
or \code{\link{sweep_dyn}}. \cr
Default is FALSE.}

\item{EXPLO_SERIES_n}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Iteration of the sweep run for the given series it belongs to,
automatically defined in \code{\link{sweep_steady}} or \code{\link{sweep_dyn}}. \cr
Default is NaN.}

\item{EXPLO_SERIES_FAMILY}{\emph{NOT TO BE USED IN SINGLE RUN}  \cr
Sweep run series family, automatically defined in
\code{\link{sweep_steady}} or \code{\link{sweep_dyn}}. \cr
Default is NaN.}

\item{HIDE_PRINTS}{\emph{OPTIONAL}  \cr
Logical value. \cr
Prints outputs details in R console if TRUE. \cr
This parameter does not hide the warnings regarding the automatic update of
the run duration in case of the emptying of a box. \cr
Default is FALSE.}

\item{to_DIGEST_DIAGRAMS}{\emph{OPTIONAL} \cr
Logical value. \cr
Edits pdf of box model diagram in RUN DIGEST folder if TRUE. \cr
Default is TRUE.}

\item{to_DIGEST_evD_PLOT}{\emph{OPTIONAL} \cr
Logical value.  \cr
Edits pdf of delta time evolution plot in RUN DIGEST folder if TRUE.\cr
Default is TRUE.}

\item{to_DIGEST_CSV_XLS}{\emph{OPTIONAL}\cr
Logical value.  \cr
Edits xlsx version of the Rda input file (ending with _IN.xlsx) and all \code{\link{ana_slvr}}
or \code{\link{num_slvr}} CSV output files in RUN DIGEST folder if TRUE. \cr
Default is FALSE.}

\item{evD_PLOT_time_as_log}{\emph{OPTIONAL}\cr
Logical value.  \cr
Print evD plot with log10 time scale as x-axis. \cr
Default is TRUE.}

\item{plot_results}{\emph{OPTIONAL} \cr
Logical value. \cr
If TRUE, plots in R session the single model run evolution of delta values and box sizes for all boxes. \cr
Default is TRUE.}

\item{save_run_outputs}{\emph{OPTIONAL} \cr
Logical value. \cr
Allows saving all run outputs to working directory (workdir). \cr
By default, run outputs are stored in the temporary directory and are erased if not exported. \cr
Default is FALSE.}
}
\value{
Calculates the time evolution of delta values and box sizes in all boxes.

\code{\link{run_isobxr}} returns by default a plot showing time evolution of delta values and box sizes
for all boxes (set plot_results = FALSE to mute the plots). \cr

\code{\link{run_isobxr}} creates a series of isotope data and metadata,
all of which are stored in a temporary directory. \cr
The user can save all outputs described below to their working directory by setting save_run_outputs = TRUE (default is FALSE). \cr

If \code{\link{run_isobxr}} is run independently,
it creates and stores all outputs in a \emph{SERIES} folder,
with the following name structure: \cr
\strong{\emph{2_RUN + SERIES_ID}}

\code{\link{run_isobxr}} base workflow:
\enumerate{
\item Automatically sets a XXXX run number between 0001 and 9999. \cr
The outputs do not overwrite possible identical previously performed runs.

\item Stores all run commands in a file with the Rda format. \cr
This file stores all commands used as arguments for solver function
(\code{\link{ana_slvr}} or \code{\link{num_slvr}}). \cr
(file name structure: \strong{\emph{SERIES_ID + XXXX + _IN.Rda}}) \cr
This encompasses the following: \cr
\enumerate{
\item \strong{CONSTS_IN}: Dataframe documenting the constants (Element, isotopes, reference ratio)
\item \strong{INITIAL_IN}:  Dataframe documenting the initial conditions of all box sizes (incl. empty boxes) \cr
and all initial delta values.
\item \strong{FLUXES_IN}: Dataframe documenting the mass fluxes of element X \cr
between all boxes (structured as a square matrix)
\item \strong{COEFFS_IN}: Dataframe documenting the isotopic fractionation coefficients \cr
between all boxes (structured as a square matrix)
\item \strong{BOX_META_IN}: Dataframe documenting box metadata \cr
(Box names, initial X masses and delta values, total inward and outward X fluxes in each box, \cr
flux balance for each box, X residence time for all balanced boxes, max run time before total emptying of each box, \cr
box infinite/finite status, system diagram coordinates)
}

\item Stores all outputs in a file with the Rda format. \cr
This file stores all data produced by the function. \cr
(file name structure: \strong{\emph{SERIES_ID + XXXX + _OUT.Rda}})

\item Updates the general log file. \cr
(file name: \strong{\emph{1_LOG.csv}})
}
}
\description{
A function to run the isobxr stable isotope box model,
assessing the design of the model and automatically running \code{\link{num_slvr}}
or \code{\link{ana_slvr}} depending on the conditions.
}
\section{Optional outputs, stored in \emph{DIGEST} folder}{


A \emph{DIGEST} folder is created to store all optional outputs of the \code{\link{run_isobxr}} function. \cr
The \emph{DIGEST} folder is created in the \emph{SERIES} folder with the following name structure: \cr
\strong{\emph{2_RUN + SERIES_ID / SERIES_ID + XXXX + DIGEST}}

\enumerate{
\item If to_DIGEST_CSV_XLS = TRUE, \cr
creates an INPUT file in the xlsx format stored in \emph{DIGEST} folder, \cr
containing all run conditions and parameters. \cr
(file name structure: \strong{\emph{in_0_INPUTS + SERIES_ID + XXXX + .xlsx}}) \cr

\item If to_DIGEST_CSV_XLS = TRUE, \cr
stores csv versions of the \code{\link{num_slvr}} or \code{\link{ana_slvr}} outputs in \emph{DIGEST} folder. \cr
See \code{\link{num_slvr}} or \code{\link{ana_slvr}} documentation for further details.

\item If to_DIGEST_DIAGRAMS = TRUE, \cr
edits a Box model diagram of flux (DIAG_FLUX pdf) of element X (mass per time unit)
between all boxes. \cr
(file name structure: \strong{\emph{in_1_DIAG_FLUX + SERIES_ID + XXXX + .pdf}})

\item If to_DIGEST_DIAGRAMS = TRUE, \cr
edits a Box model diagram of isotope fractionation coefficients (DIAG_COEFF pdf)
between all boxes. \cr
(file name structure: \strong{\emph{in_2_DIAG_COEFF + SERIES_ID + XXXX + .pdf}})

\item If to_DIGEST_evD_PLOT = TRUE, \cr
edits a pdf plot of the time dependent evolution of delta values
together with the evolution of the box sizes (masses of element X). \cr
The time x-axis is a logarithmic scale by default but can be set
to linear scale with the evD_PLOT_time_as_log parameter, if set to FALSE.
(file name structure: \strong{\emph{out_0_PLOT_evD + SERIES_ID + XXXX + .pdf}})

}
}

\examples{
# Example 1. {ABC}, closed, balanced
# for more information see tutorial at
# https://ttacail.github.io/isobxr_web/vgn_04_Run_isobxr_tutorial.html#22_Run_the_model

# This is an example using the tutorial files embedded in package data
# It can be run as such.
run_isobxr(workdir = "/Users/username/Documents/1_ABC_tutorial",
           SERIES_ID = "ABC_closed_balanced", # series ID of the set of runs
           flux_list_name = "Fx1_ABC_closed_bal", # which flux list from FLUXES sheet
           coeff_list_name = "a1", # which coefficients list from COEFFS sheet
           t_lim = 2500, # how long do I want to run
           nb_steps = 250, # how many steps over this run duration
           time_units = c("d", "yr"), # run time units (days), plot time units (years)
           to_DIGEST_evD_PLOT = FALSE, # do not export plots as pdf files
           to_DIGEST_CSV_XLS = FALSE, # do not export datasets as csv and xlsx files
           to_DIGEST_DIAGRAMS = FALSE) # do not export diagrams as pdf files
}
\seealso{
Documentation on \code{\link{num_slvr}} or \code{\link{ana_slvr}} functions.
}
