% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isd_parser_line.R
\name{isd_parse_line}
\alias{isd_parse_line}
\title{Parse NOAA ISD/ISH data files - line by line}
\usage{
isd_parse_line(x, additional = TRUE, as_data_frame = TRUE)
}
\arguments{
\item{x}{(character) a single ISD line}

\item{additional}{(logical) include additional and remarks data sections
in output. Default: \code{TRUE}}

\item{as_data_frame}{(logical) output a tibble. Default: \code{FALSE}}
}
\value{
A tibble (data.frame)
}
\description{
Parse NOAA ISD/ISH data files - line by line
}
\examples{
path <- system.file('extdata/024130-99999-2016.gz', package = "isdparser")
lns <- readLines(path, encoding = "latin1")
isd_parse_line(lns[1])
isd_parse_line(lns[1], FALSE)

res <- lapply(lns[1:1000], isd_parse_line)
library("data.table")
library("tibble")
as_data_frame(
 rbindlist(res, use.names = TRUE, fill = TRUE)
)

# only control + mandatory sections
isd_parse_line(lns[10], additional = FALSE)
isd_parse_line(lns[10], additional = TRUE)
}
\references{
ftp://ftp.ncdc.noaa.gov/pub/data/noaa
}
\seealso{
\code{\link{isd_parse}}
}
