% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{ar1_sim_conditional}
\alias{ar1_sim_conditional}
\title{Simulate from a stationary Gaussian AR(1) process.}
\usage{
ar1_sim_conditional(pred_times, obs_times, x_obs, rho, sigma, mu_pred = 0,
  mu_obs = 0)
}
\arguments{
\item{pred_times}{A vector of time points to simulate at.}

\item{obs_times}{A vector of time points at which observations have been
made.}

\item{x_obs}{The observed values of the process.}

\item{rho}{A real number strictly less than 1 in absolute value.}

\item{sigma}{A positive real number.}

\item{mu_pred}{A vector or scalar with expected values.}

\item{mu_obs}{A vector or scalar with expected values.}
}
\value{
A vector of length \code{length(pred_times)} with the process
  values.
}
\description{
Simulate from a stationary Gaussian AR(1) process at \code{n} consecutive
time points.
}
\examples{
t_pred <- c(1, 3, 6:8, 10)
t_obs <- c(2, 5, 11:12)
x_obs <- rnorm(4)
rho <- 0.5
sigma <- 1
# Means equal 0
ar1_sim_conditional(t_pred, t_obs, x_obs, rho, sigma)
# Time-varying means
mu_pred <- t_pred + rnorm(length(t_pred))
mu_obs <- t_obs + rnorm(length(t_obs))
ar1_sim_conditional(t_pred, t_obs, x_obs + mu_obs, rho, sigma,
                    mu_pred, mu_obs)
}
