% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_training.R
\name{boxplot_training}
\alias{boxplot_training}
\title{Box Plot Training}
\usage{
boxplot_training(
  irace_results,
  iteration = NULL,
  id_configurations = NULL,
  ...
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{iteration}{Numeric, iteration number that should be included in the plot (example: \code{iteration = 5})
When no iteration and no id_condigurations are provided, the iterations is assumed to be
the last one performed by irace.

The performance data is obtained from the evaluations performed by irace
during the execution process. This implies that the number of evaluations
can differ between configurations due to the elimination process applied by
irace. This plot, consequently, does not provide a complete compaarison of
two configurations, for a fair comparison use the test data plot.}

\item{id_configurations}{Numeric vector, configurations ids whose performance should be included in the plot.
If no ids are provided, the configurations ids are set as the elite configuration ids
of the selected iteration (last iteration by default)
(example: \code{id_configurations = c(20,50,100,300,500,600,700)}).}

\item{...}{Other arguments passed to \code{\link[=boxplot_performance]{boxplot_performance()}}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} boxplot object
}
\description{
Creates a box plot that displays the performance of a set of configurations
on the training instances. Performance data is obtained from the evaluations
performed by irace during the execution process. This implies that the
number of evaluations can differ between configurations.
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
boxplot_training(iraceResults)
\donttest{ 
boxplot_training(iraceResults, iteration = 5)
boxplot_training(iraceResults, id_configurations = c(23,28,29))
}
}
\seealso{
\code{\link[=boxplot_test]{boxplot_test()}} \code{\link[=boxplot_performance]{boxplot_performance()}}
}
