% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{ds_spec}
\alias{ds_spec}
\alias{tst_spec}
\title{Create dataset and time series table specifications for IPUMS NHGIS extract
requests}
\usage{
ds_spec(
  name,
  data_tables = NULL,
  geog_levels = NULL,
  years = NULL,
  breakdown_values = NULL
)

tst_spec(name, geog_levels = NULL, years = NULL)
}
\arguments{
\item{name}{Name of the dataset or time series table.}

\item{data_tables}{Vector of summary tables to retrieve for the given
dataset.}

\item{geog_levels}{Geographic levels (e.g. \code{"county"} or \code{"state"})
at which to obtain data for the given dataset or time series table.}

\item{years}{Years for which to obtain the data for the given dataset or time
series table.

For time series tables, all years are selected by default. For datasets,
use \code{"*"} to select all available years. Use
\code{\link[=get_metadata_nhgis]{get_metadata_nhgis()}} to determine if a dataset allows year selection.}

\item{breakdown_values}{\href{https://www.nhgis.org/frequently-asked-questions-faq#breakdowns}{Breakdown values}
to apply to the given dataset.}
}
\value{
A \code{ds_spec} or \code{tst_spec} object.
}
\description{
Provide specifications for individual datasets and time series
tables when defining an IPUMS NHGIS extract request.

Use \code{\link[=get_metadata_nhgis]{get_metadata_nhgis()}} to identify available values for dataset and
time series table specification parameters.

Learn more about NHGIS extract definitions in
\code{vignette("ipums-api-nhgis")}.
}
\details{
In general, \code{data_tables} and \code{geog_levels} are required for all
dataset specifications, and \code{geog_levels} are required for all
time series table specifications.

However, it is possible to make a temporary specification for an incomplete
dataset or time series table by omitting these values. This supports the
syntax used when modifying an existing extract (see
\code{\link[=add_to_extract.nhgis_extract]{add_to_extract()}} or
\code{\link[=remove_from_extract.nhgis_extract]{remove_from_extract()}}).
}
\examples{
dataset <- ds_spec(
  "2013_2017_ACS5a",
  data_tables = c("B00001", "B01002"),
  geog_levels = "state"
)

tst <- tst_spec(
  "CW5",
  geog_levels = c("county", "tract"),
  years = "1990"
)

# Use variable specifications in an extract definition:
define_extract_nhgis(
  description = "Example extract",
  datasets = dataset,
  time_series_tables = tst
)
}
\keyword{internal}
