% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.r
\docType{data}
\name{ipums_callback}
\alias{ipums_callback}
\alias{IpumsChunkCallback}
\alias{IpumsSideEffectCallback}
\alias{IpumsDataFrameCallback}
\alias{IpumsListCallback}
\alias{IpumsBiglmCallback}
\title{Callback classes}
\description{
These classes are used to define callback behaviors that have been adapted
for use on IPUMS microdata extracts. Though the callbacks from the
readr package will work, they will not take divide out implicit decimals
or add value/variable labels to the data.
}
\details{
\describe{
 \item{IpumsSideEffectCallback}{
   Callback function that is used only for side effects, no results are returned.
   Initialize with a function that takes 2 arguments x (which will be the data chunk)
   and an integer that indicates the position of the first observation in the chunk.
   If the function returns \code{FALSE}, no more chunks will be read.
 }
 \item{IpumsDataFrameCallback}{
 Callback function that combines each result together into a data.frame at the end.
   Initialize the same was as IpumsSideEffectCallback, and the results from the
   function will be fed into a data.frame.
 }
 \item{IpumsListCallback}{
   Callback function that returns a list, where each item is the result from a chunk.
   Initalize the same was as IpumsSideEffectCallback.
 }
 \item{IpumsBiglmCallback}{
   Callback function that performs a regression on the full dataset, one chunk
   at a time using the biglm package. Initialize with arguments \code{model} (A
   formula of your model and \code{prep} a function like the other callback arguments
   that prepares the data before running the regression. Other arguments are
   passed to biglm.
 }
 \item{IpumsChunkCallback}{
   (Only needed for advanced usage) Callback interface definition, all
    callback functions for IPUMS data should inherit from this class, and should
    use private method \code{ipumsify} on the data to handle implicit decimals
    and value labels.
  }
}
}
\keyword{datasets}
\keyword{internal}
