context("Test IPv6 Operarions")

c("2001:db8::1",
  "2001:e42:101:2:202:181:99:52",
  "2400:8500:1801:417:118:27:35:213",
  "x",
  "2a02:2770:8:0:21a:4aff:fe96:7a47",
  "2400:2413:32c0:8:21a:92ff:fe22:c7b3",
  "2001:44b8:3138:c570:250:56ff:fe9c:c19b",
  "240f:a2:2e5:1:214:c2ff:fec8:1673",
  "2001:e42:102:1103:153:121:36:109",
  "2401:2500:203:2f:153:127:108:158"
) -> tst6

expect_equal(
  ipv6_to_bytes(tst6),
  list(
    as.raw(c(
      0x20, 0x01, 0x0d, 0xb8, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
    )),
    as.raw(c(
      0x20, 0x01, 0x0e, 0x42, 0x01, 0x01, 0x00, 0x02,
      0x02, 0x02, 0x01, 0x81, 0x00, 0x99, 0x00, 0x52
    )),
    as.raw(c(
      0x24, 0x00, 0x85, 0x00, 0x18, 0x01, 0x04, 0x17,
      0x01, 0x18, 0x00, 0x27, 0x00, 0x35, 0x02, 0x13
    )),
    raw(0),
    as.raw(c(
      0x2a, 0x02, 0x27, 0x70, 0x00, 0x08, 0x00, 0x00,
      0x02, 0x1a, 0x4a, 0xff, 0xfe, 0x96, 0x7a, 0x47
    )),
    as.raw(c(
      0x24, 0x00, 0x24, 0x13, 0x32, 0xc0, 0x00, 0x08,
      0x02, 0x1a, 0x92, 0xff, 0xfe, 0x22, 0xc7, 0xb3
    )),
    as.raw(c(
      0x20, 0x01, 0x44, 0xb8, 0x31, 0x38, 0xc5, 0x70,
      0x02, 0x50, 0x56, 0xff, 0xfe, 0x9c, 0xc1, 0x9b
    )),
    as.raw(c(
      0x24, 0x0f, 0x00, 0xa2, 0x02, 0xe5, 0x00, 0x01,
      0x02, 0x14, 0xc2, 0xff, 0xfe, 0xc8, 0x16, 0x73
    )),
    as.raw(c(
      0x20, 0x01, 0x0e, 0x42, 0x01, 0x02, 0x11, 0x03,
      0x01, 0x53, 0x01, 0x21, 0x00, 0x36, 0x01, 0x09
    )),
    as.raw(c(
      0x24, 0x01, 0x25, 0x00, 0x02, 0x03, 0x00, 0x2f,
      0x01, 0x53, 0x01, 0x27, 0x01, 0x08, 0x01, 0x58
    ))
  )
)

expect_equal(
  ipv6_to_nibble(tst6),
  c(
    "1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.8.b.d.0.1.0.0.2",
    "2.5.0.0.9.9.0.0.1.8.1.0.2.0.2.0.2.0.0.0.1.0.1.0.2.4.e.0.1.0.0.2",
    "3.1.2.0.5.3.0.0.7.2.0.0.8.1.1.0.7.1.4.0.1.0.8.1.0.0.5.8.0.0.4.2",
    NA,
    "7.4.a.7.6.9.e.f.f.f.a.4.a.1.2.0.0.0.0.0.8.0.0.0.0.7.7.2.2.0.a.2",
    "3.b.7.c.2.2.e.f.f.f.2.9.a.1.2.0.8.0.0.0.0.c.2.3.3.1.4.2.0.0.4.2",
    "b.9.1.c.c.9.e.f.f.f.6.5.0.5.2.0.0.7.5.c.8.3.1.3.8.b.4.4.1.0.0.2",
    "3.7.6.1.8.c.e.f.f.f.2.c.4.1.2.0.1.0.0.0.5.e.2.0.2.a.0.0.f.0.4.2",
    "9.0.1.0.6.3.0.0.1.2.1.0.3.5.1.0.3.0.1.1.2.0.1.0.2.4.e.0.1.0.0.2",
    "8.5.1.0.8.0.1.0.7.2.1.0.3.5.1.0.f.2.0.0.3.0.2.0.0.0.5.2.1.0.4.2"
  )
)

expect_equal(
  ipv6_to_nibble(tst6, ip6_arpa = TRUE),
  c(
    "1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.8.b.d.0.1.0.0.2.ip6.arpa.",
    "2.5.0.0.9.9.0.0.1.8.1.0.2.0.2.0.2.0.0.0.1.0.1.0.2.4.e.0.1.0.0.2.ip6.arpa.",
    "3.1.2.0.5.3.0.0.7.2.0.0.8.1.1.0.7.1.4.0.1.0.8.1.0.0.5.8.0.0.4.2.ip6.arpa.",
    NA,
    "7.4.a.7.6.9.e.f.f.f.a.4.a.1.2.0.0.0.0.0.8.0.0.0.0.7.7.2.2.0.a.2.ip6.arpa.",
    "3.b.7.c.2.2.e.f.f.f.2.9.a.1.2.0.8.0.0.0.0.c.2.3.3.1.4.2.0.0.4.2.ip6.arpa.",
    "b.9.1.c.c.9.e.f.f.f.6.5.0.5.2.0.0.7.5.c.8.3.1.3.8.b.4.4.1.0.0.2.ip6.arpa.",
    "3.7.6.1.8.c.e.f.f.f.2.c.4.1.2.0.1.0.0.0.5.e.2.0.2.a.0.0.f.0.4.2.ip6.arpa.",
    "9.0.1.0.6.3.0.0.1.2.1.0.3.5.1.0.3.0.1.1.2.0.1.0.2.4.e.0.1.0.0.2.ip6.arpa.",
    "8.5.1.0.8.0.1.0.7.2.1.0.3.5.1.0.f.2.0.0.3.0.2.0.0.0.5.2.1.0.4.2.ip6.arpa."
  )
)

