% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cidr.r
\name{ips_in_cidrs}
\alias{ips_in_cidrs}
\title{Determine if a vector if IPv4 addresses are in a vector of CIDRs}
\usage{
ips_in_cidrs(ips, cidrs)
}
\arguments{
\item{ips}{character vector or numeric vector of IPv4 addresses}

\item{cidrs}{character vector or numeric vector of IPv4 CIDRs}
}
\value{
\code{data_frame} with \code{ips} column and a logical \code{in_cdir} column
}
\description{
Determine if a vector if IPv4 addresses are in a vector of CIDRs
}
\note{
auto-appends \code{/32} if a bare IPv4 is detected
}
\examples{
ips_in_cidrs(
  c("4.3.2.1", "1.2.3.4", "1.20.113.10", "5.190.145.5"),
  c("5.190.144.0/21", "1.20.113.0/24")
)
}
