## ----eval=FALSE----------------------------------------------------------
#  ips <- c("192.168.0.1", "2607:f8b0:4006:80b::aaa",
#           "the next IP is also invalid", "256.256.190.900")
#  ip_classify(ips)
#  [1] "IPv4"    "IPv6"    "Invalid" "Invalid"

## ----eval=FALSE----------------------------------------------------------
#  #Dotted-decimal to numeric
#  ips <- c("192.168.0.1","172.18.0.0","172.18.0.15")
#  numeric_ips <- ip_to_numeric(ips)
#  numeric_ips
#  [1] 3232235521 2886860800 2886860815
#  
#  #And back again
#  numeric_to_ip(numeric_ips)
#  [1] "192.168.0.1" "172.18.0.0"  "172.18.0.15"

## ----eval=FALSE----------------------------------------------------------
#  hostname_to_ip("lga15s49-in-f6.1e100.net")
#  [[1]]
#  [1] "173.194.123.102"

## ----eval=FALSE----------------------------------------------------------
#  ip_to_hostname("173.194.123.10")
#  [[1]]
#  [1] "lga15s46-in-f10.1e100.net"

## ----eval = FALSE--------------------------------------------------------
#  range_boundaries(c("172.18.0.0/28","148.20.57.0/28","148.20.57.0/24")
#     minimum_ip    maximum_ip
#  1  172.18.0.0   172.18.0.15
#  2 148.20.57.0  148.20.57.15
#  3 148.20.57.0 148.20.57.255

## ----eval = FALSE--------------------------------------------------------
#  range_generate(range = "148.20.57.0/28")
#  [1]  "148.20.57.0"  "148.20.57.1"  "148.20.57.2"  "148.20.57.3"  "148.20.57.4"
#  [6]  "148.20.57.5"  "148.20.57.6"  "148.20.57.7"  "148.20.57.8" "148.20.57.9"
#  [11] "148.20.57.10" "148.20.57.11" "148.20.57.12" "148.20.57.13" "148.20.57.14" "148.20.57.15"

## ----eval = FALSE--------------------------------------------------------
#  ips <- c("148.20.57.15", "148.20.57.255")
#  ip_in_range(ips, "148.20.57.0/28")
#  [1]  TRUE FALSE

## ----eval=FALSE----------------------------------------------------------
#  ip_random(n = 5)

