% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async-interrupt.R
\docType{data}
\name{AsyncInterruptor}
\alias{AsyncInterruptor}
\title{An interruptor useful for stopping child processes.}
\arguments{
\item{queue}{a shiny queue}

\item{msg}{An error message string.}
}
\description{
This class is a simple wrapper around a Queue object
making adding interrupt checking to future code easy
to implement and read.
}
\details{
\strong{Methods}
  \describe{
    \item{\code{initialize(queue=shinyQueue())}}{
      Creates a new interruptor.
    }
    \item{\code{interrupt(msg="Signaled Interrupt")}}{
      Signals an interrupt
    }
    \item{\code{execInterrupts()}}{
      Executes anything pushed to the queue, including interrupts.
    }
    \item{\code{getInterrupts()}}{
      Gets the result of the queue's executing, not throwing the interrupts.
    }
  }
}
\examples{
library(future)
strategy <- "future::multisession"
plan(strategy)
inter <- AsyncInterruptor$new()
fut <- future({
  for(i in 1:100){
    Sys.sleep(.01)
    inter$execInterrupts()
  }
})
inter$interrupt("Error: Stop Future")
try(value(fut))
inter$destroy()

# Clean up multisession cluster
plan(sequential)

}
\keyword{datasets}
