% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biclustFunc.R
\name{biclustFunc}
\alias{biclustFunc}
\title{biclustFunc function}
\usage{
biclustFunc(Qmat, admixRatioThs = 0.5, method = "average")
}
\arguments{
\item{Qmat}{is a Q matrix that contains admixture ratios of all individuals where the \code{Qmat[i,j]} represents the admixture ratio of ancestor j for individual i.}

\item{admixRatioThs}{is a threshold to determine that if a cluster has \code{maxDiffAdmixRatio} lower than threshold, then the cluster is a homogeneous cluster.}

\item{method}{is a method parameter of \code{hclust} object for hierarchical clustering analysis. The default is "average".}
}
\value{
This function returns binary clustering results.

\item{heteroFlag}{ is a flag that represents a status whether a given cluster is heterogeneous (having sub-clusters). It is TRUE if \code{maxDiffAdmixRatio >= admixRatioThs}.}
\item{clusterInx}{is a vector of clustering assignment where \code{indexClsVec[i]} is a cluster number of individual i.}
\item{meanDiffAdmixRatio}{is a vector of magnitude-difference of admixture ratios.
It is calculated by splitting a given cluster into two sub-clusters. Then, we take the absolute on the difference between mean admixture ratios of sub-clusters. }
\item{Qmat1}{is a Q matrix of sub-cluster #1 after splitting a given cluster into two sub-clusters that contains admixture ratios of all individuals where the \code{Qmat[i,j]} represents the admixture ratio of ancestor j for individual i.}
\item{Qmat2}{is a Q matrix of sub-cluster #2 after splitting a given cluster into two sub-clusters that contains admixture ratios of all individuals where the \code{Qmat[i,j]} represents the admixture ratio of ancestor j for individual i.}
\item{maxDiffAdmixRatio}{is a maximum of magnitude-difference of admixture ratios for a given cluster before splitting into two sub-clusters. }
}
\description{
biclustFunc is a binary clustering function using hierarchical clustering.
}
\examples{
# Running biclustFunc on Q matrix of 27 human population dataset where K = 12
obj<-biclustFunc(Qmat=ipADMIXTURE::human27pop_Qmat[[11]], admixRatioThs =0.15)

}
