% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identification_tests.R
\name{IterativeKleibergenPaap2006BetaRankTest}
\alias{IterativeKleibergenPaap2006BetaRankTest}
\title{Asset Pricing Model Identification via Iterative Kleibergen-Paap 2006 Beta Rank Test}
\usage{
IterativeKleibergenPaap2006BetaRankTest(
  returns,
  factors,
  target_level = 0.05,
  check_arguments = TRUE
)
}
\arguments{
\item{returns}{A matrix of test asset excess returns with dimensions \verb{n_observations x n_returns}.}

\item{factors}{A matrix of risk factors with dimensions \verb{n_observations x n_factors}.}

\item{target_level}{A numeric value specifying the significance level for the test. For each
hypothesis test \code{H: rank(beta) = q}, the significance level is adjusted to
\code{target_level / n_factors}. The default is \code{0.05}.}

\item{check_arguments}{Logical flag indicating whether to perform internal checks of the
function's arguments. Defaults to \code{TRUE}.}
}
\value{
A list containing estimates of the regression loading rank and the associated
iterative Kleibergen-Paap 2006 beta rank statistics and p-values for each \code{q}.
}
\description{
Evaluates the rank of regression loadings in an asset pricing model using the
iterative Kleibergen-Paap (2006) \url{doi:10.1016/j.jeconom.2005.02.011} beta rank test.
It systematically tests the null hypothesis
for each potential rank \verb{q = 0, ..., n_factors - 1} and estimates the rank as the smallest \code{q}
that has a p-value below the significance level, adjusted for the number of factors.
The function presupposes more returns than factors (\code{n_factors < n_returns}).
All the details can be found in Kleibergen-Paap (2006) \url{doi:10.1016/j.jeconom.2005.02.011}.
}
\examples{
# import package data on 15 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

# compute the model identification test
hj_test = ChenFang2019BetaRankTest(returns, factors)

}
