% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_margins.R
\name{as_huxtable.sim_margins}
\alias{as_huxtable.sim_margins}
\title{Create tabular output for simple margins analysis}
\usage{
as_huxtable.sim_margins(x, format = "{estimate} ({std.error})",
  sig.levels = c(`***` = 0.001, `**` = 0.01, `*` = 0.05, `#` = 0.1),
  digits = getOption("jtools-digits", 2), conf.level = 0.95,
  intercept = attr(x, "cond.int"), int.format = format, ...)
}
\arguments{
\item{x}{A \code{sim_margins} object.}

\item{format}{The method for sharing the slope and associated uncertainty.
Default is \code{"{estimate} ({std.error})"}. See the instructions for the
\code{error_format} argument of \code{\link[=export_summs]{export_summs()}} for more on your
options.}

\item{sig.levels}{A named vector in which the values are potential p value
thresholds and the names are significance markers (e.g., "*") for when
p values are below the threshold. Default is
\code{c(`***` = .001, `**` = .01, `*` = .05, `#` = .1)}.}

\item{digits}{How many digits should the outputted table round to? Default
is 2.}

\item{conf.level}{How wide the confidence interval should be, if it
is used. .95 (95\% interval) is the default.}

\item{intercept}{Should conditional intercepts be included? Default is
whatever the \code{cond.int} argument to \code{x} was.}

\item{int.format}{If conditional intercepts were requested, how should
they be formatted? Default is the same as \code{format}.}

\item{...}{Ignored.}
}
\description{
This function converts a \code{sim_margins} object into a
\code{huxtable} object, making it suitable for use in external documents.
}
\details{
For more on what you can do with a \code{huxtable}, see \pkg{huxtable}.
}
