% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{vartest}
\alias{vartest}
\title{F Test to compare two variances of objects of class \code{intRvals}}
\usage{
vartest(x, y, ratio = 1, alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95)
}
\arguments{
\item{x}{an object of class \code{intRvals}, usually a result of a call to \link[intRvals]{estinterval}}

\item{y}{an (optional) object of class \code{intRvals}, usually a result of a call to \link[intRvals]{estinterval}}

\item{ratio}{the hypothesized ratio of the population variances of \code{x} and \code{y}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "\code{two.sided}" (default), "\code{greater}" or "\code{less}". You can specify just the initial letter.}

\item{conf.level}{confidence level for the returned confidence interval}
}
\value{
A list with class "\code{htest}" containing the same components as in \link[stats]{var.test}
}
\description{
Performs an F test to compare the variances of objects of class \code{intRvals}
}
\details{
The null hypothesis is that the ratio of the variances of the
data to which the models \code{x} and \code{y} were fitted, is equal to ratio.
}
\examples{
data(goosedrop)
dr=estinterval(goosedrop$interval)
# split the interval data into two periods
data.beforeMay=goosedrop[goosedrop$date<as.POSIXct('2013-05-01'),]
data.afterMay=goosedrop[goosedrop$date>as.POSIXct('2013-05-01'),]
dr.beforeMay=estinterval(data.beforeMay$interval)
dr.afterMay=estinterval(data.afterMay$interval)
# perform an F test
vartest(dr.beforeMay,dr.afterMay)

}
