% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{fold}
\alias{fold}
\title{Folds observed arrival intervals to a fundamental interval}
\usage{
fold(object, take.sample = F, sigma.within = NA, silent = F)
}
\arguments{
\item{object}{an object of class \code{intRvals}, usually a result of a call to \link[intRvals]{estinterval}}

\item{take.sample}{when \code{TRUE} the number of folds of the fundamental interval is sampled randomly, taking into account the probability weight of each possibility. When \code{FALSE} the fold with the highest probability weight is taken.}

\item{sigma.within}{(optional) numeric value with an assumed within-group/subject standard deviation, or '\code{auto}' to estimate it automatically using \link[intRvals]{partition}.}

\item{silent}{logical, if \code{TRUE} print no text to console}
}
\value{
numeric vector with intervals folded into the fundamental interval
}
\description{
Folds observed arrival intervals with missed observations back to their most likely fundamental interval
}
\details{
Arrival intervals containing missed observations are folded to their most likely
fundamental interval according to a fit of the distribution of intervals by \link[intRvals]{estinterval}.

There is inherent uncertainty on how many missed arrival events an observed interval contains, and therefore to
which fundamental interval it should be folded. Intervals folded to the fundamental
can therefore introduce extra unexplained variance.

The default is to fold intervals to the
fundamental with the highest probability weight (\code{take.sample = F}). Alternatively, randomly sampled intervals
can be generated, that take into account the probability weights of each possible fold (\code{take.sample = T}).

Intervals \code{x} are transformed to their fundamental interval according to
\deqn{\mu+(x-i*\mu)/\sqrt i}{\mu+(x-i*\mu)/\sqrt i}
with \code{i-1} the estimated number of missed observations within the interval. This transformation scales appropriately
with the expected broadening of the standard distributions \eqn{\phi(x | i \mu,\sqrt i \sigma)} with \code{i} in \link[intRvals]{intervalpdf}.

When no \code{sigma.within} is provided, \eqn{\mu} equals the mean arrival rate, estimated by \link[intRvals]{estinterval}.

When \code{sigma.within} is '\code{auto}', \code{sigma.within} is estimated using \link[intRvals]{partition}.

When \code{sigma.within} is a user-specified numeric value or '\code{auto}', \eqn{\mu} is estimated for each group (
as specified in the group argument of \link[intRvals]{estinterval}),
by maximizing the log-likelihood of \link[intRvals]{intervalpdf}, with its \code{data} argument equals to the intervals of the group,
its \code{sigma} argument equal to \code{sigma.within}, and its remaining arguments taken from \code{object}.

Intervals assigned to the \code{fpp} component (see \link[intRvals]{estinterval}) are not
folded, and return as \code{NA} values.
}
\examples{
dr=estinterval(goosedrop$interval,group=goosedrop$bout_id)
# fold assuming no within-group variation:
interval.fundamental=fold(dr)
# test whether there is evidence for within-group variation:
partition(dr)$`p<alpha`   #> TRUE
# there is evidence, therefore better to fold
# while accounting for within-group variation:
interval.fundamental=fold(dr,sigma.within='auto')
}
