% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_package_model.R
\name{stan_package_model}
\alias{stan_package_model}
\title{Get a pre-compiled Stan model built into an R package.}
\usage{
stan_package_model(
  name,
  package,
  library = NULL,
  cmdstan_install = Sys.getenv("CMDSTAN_INSTALL", unset = "")
)
}
\arguments{
\item{name}{Character of length 1, base name of the Stan model file
(without the containing directory or \code{.stan} file extension).}

\item{package}{Character of length 1, name of the R package to look
for the built-in Stan model.}

\item{library}{Character of length 1 or \code{NULL}, library path
to look for the package with the built-in Stan model.
Passed to the \code{lib.loc} argument of \code{system.file()}.}

\item{cmdstan_install}{Character of length 1, how to look for an installed
copy of CmdStan. See \url{https://wlandau.github.io/instantiate/} for details.
Choices:
\enumerate{
\item \code{""} (default): look at the original value that the \code{CMDSTAN_INSTALL}
environment variable contained when \code{instantiate} at the time
when it was installed.
If it was \code{"implicit"} or \code{"fixed"}, then choose
the corresponding option below. Otherwise, default to \code{"implicit"}.
\item \code{"implicit"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. As explained in the \code{cmdstanr} documentation,
the output of \code{cmdstanr::cmdstan_path()} depends
on the current value of the \code{CMDSTAN} environment variable.
The \code{cmdstanr} package must be installed. If it
is not installed, then \code{stan_cmdstan_path()}
returns the empty string \code{""}.
\item \code{"fixed"}: Use the path to CmdStan that was originally
contained in \code{Sys.getenv("CMDSTAN")} at the time when \code{instantiate}
was installed.
}}
}
\value{
An \code{R6} Stan model object from the \code{cmdstanr} package.
Please visit the documentation website at \url{https://mc-stan.org/cmdstanr/}
for detailed information on the composition of this model object
and how to use it to conduct Bayesian inference.
}
\description{
Get the \code{cmdstanr} model object for a pre-compiled Stan
model inside a package.
}
\details{
Packages configured with \code{instantiate} compile their Stan
models on installation. Then the \code{stan_package_model()} function
retrieves the \code{cmdstanr::cmdstan_model()} object without needing
to re-compile the model. Please see the documentation website
of the \code{instantiate} package for examples.
}
\examples{
# Please see the documentation website of the {instantiate} package
#   for examples.
}
\keyword{packages}
