if (require("testthat") && require("insight") && require("survival")) {
  context("insight, model_info")

  data("ovarian")
  m1 <- survreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, dist = "exponential")

  test_that("model_info", {
    expect_false(model_info(m1)$is_linear)
    expect_true(model_info(m1)$is_exponential)
  })

  test_that("find_predictors", {
    expect_identical(find_predictors(m1), list(conditional = c("ecog.ps", "rx")))
    expect_identical(find_predictors(m1, flatten = TRUE), c("ecog.ps", "rx"))
    expect_null(find_predictors(m1, effects = "random"))
  })

  test_that("find_random", {
    expect_null(find_random(m1))
  })

  test_that("get_random", {
    expect_warning(get_random(m1))
  })

  test_that("find_response", {
    expect_identical(find_response(m1), "Surv(futime, fustat)")
  })

  test_that("get_response", {
    expect_equal(get_response(m1), ovarian[, c("futime", "fustat")])
  })

  test_that("get_predictors", {
    expect_equal(colnames(get_predictors(m1)), c("ecog.ps", "rx"))
  })

  test_that("link_inverse", {
    expect_equal(link_inverse(m1)(.2), exp(.2), tolerance = 1e-5)
  })

  test_that("get_data", {
    expect_equal(nrow(get_data(m1)), 26)
    expect_equal(colnames(get_data(m1)), c("futime", "fustat", "Surv(futime, fustat)", "ecog.ps", "rx"))
  })

  test_that("find_formula", {
    expect_length(find_formula(m1), 1)
    expect_equal(
      find_formula(m1),
      list(conditional = as.formula("Surv(futime, fustat) ~ ecog.ps + rx"))
    )
  })

  test_that("find_terms", {
    expect_equal(find_terms(m1), list(response = c("futime", "fustat"), conditional = c("ecog.ps", "rx")))
    expect_equal(find_terms(m1, flatten = TRUE), c("futime", "fustat", "ecog.ps", "rx"))
  })

  test_that("n_obs", {
    expect_equal(n_obs(m1), 26)
  })

  test_that("linkfun", {
    expect_false(is.null(link_function(m1)))
  })

  test_that("find_parameters", {
    expect_equal(
      find_parameters(m1),
      list(
        conditional = c("(Intercept)", "ecog.ps", "rx")
      )
    )
    expect_equal(nrow(get_parameters(m1)), 3)
    expect_equal(get_parameters(m1)$parameter, c("(Intercept)", "ecog.ps", "rx"))
  })

  test_that("is_multivariate", {
    expect_false(is_multivariate(m1))
  })
}
