% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_names.R
\name{clean_names}
\alias{clean_names}
\title{Get clean names of model terms}
\usage{
clean_names(x)
}
\arguments{
\item{x}{A fitted model, or a character vector.}
}
\value{
The "cleaned" variable names as character vector, i.e. pattern
  like \code{s()} for splines or \code{log()} are removed from
  the model terms.
}
\description{
This function "cleans" names of model terms (or a character
  vector with such names) by removing patterns like \code{log()} or
  \code{as.factor()} etc.
}
\note{
If \code{x} is a regression model, this function is equal to calling
  \code{find_terms()}.
}
\examples{
# example from ?stats::glm
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- c(gl(3, 1, 9))
treatment <- gl(3, 3)
m <- glm(counts ~ log(outcome) + as.factor(treatment), family = poisson())
clean_names(m)
}
