% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_rope.R
\name{format_rope}
\alias{format_rope}
\title{Percentage in ROPE formatting}
\usage{
format_rope(rope_percentage, name = "in ROPE", digits = 2)
}
\arguments{
\item{rope_percentage}{Value or vector of percentages in ROPE.}

\item{name}{Name prefixing the text. Can be \code{NULL}.}

\item{digits}{Number of significant digits. May also be \code{"scientific"}
to return exact p-values in scientific notation, or \code{"apa"} to use
an APA-style for p-values (e.g., p < .01, p < .05, etc.). If
\code{"scientific"}, control the number of digits by adding the value as
suffix, e.g. \code{digits = "scientific4"} to have scientific notation
with 4 decimal places.}
}
\value{
A formatted string.
}
\description{
Percentage in ROPE formatting
}
\examples{
format_rope(c(0.02, 0.12, 0.357, 0))
format_rope(c(0.02, 0.12, 0.357, 0), name = NULL)
}
