% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predicted.R
\name{get_predicted}
\alias{get_predicted}
\alias{get_predicted.default}
\alias{get_predicted.lm}
\alias{get_predicted.merMod}
\title{Predicted values}
\usage{
get_predicted(x, ...)

\method{get_predicted}{default}(x, newdata = NULL, ...)

\method{get_predicted}{lm}(
  x,
  newdata = NULL,
  ci = 0.95,
  ci_type = "confidence",
  vcov_estimation = NULL,
  vcov_type = NULL,
  vcov_args = NULL,
  ...
)

\method{get_predicted}{merMod}(
  x,
  newdata = NULL,
  ci = 0.95,
  ci_type = "confidence",
  transform = "response",
  include_random = TRUE,
  bootstrap = FALSE,
  vcov_estimation = NULL,
  vcov_type = NULL,
  vcov_args = NULL,
  ...
)
}
\arguments{
\item{x}{A model.}

\item{...}{Not used.}

\item{newdata}{An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.}

\item{ci}{The interval level (default \code{0.95}, i.e., 95\% CI).}

\item{ci_type}{Can be \code{"prediction"} or \code{"confidence"}. Prediction intervals show the range that likely contains the value of a new observation (in what range it would fall), whereas confidence intervals reflect the uncertainty around the estimated parameters (and gives the range of the link; for instance of the regression line in a linear regressions). Prediction intervals account for both the uncertainty in the model's parameters, plus the random variation of the individual values. Thus, prediction intervals are always wider than confidence intervals. Moreover, prediction intervals will not necessarily become narrower as the sample size increases (as they do not reflect only the quality of the fit). This applies mostly for "simple" linear models (like \code{lm}), as for other models (e.g., \code{glm}), prediction intervals are somewhat useless (for instance, for a binomial model for which the dependent variable is a vector of 1s and 0s, the prediction interval is... \code{[0, 1]}).}

\item{vcov_estimation}{String, indicating the suffix of the \code{vcov*()}-function
from the \pkg{sandwich} or \pkg{clubSandwich} package, e.g. \code{vcov_estimation = "CL"}
(which calls \code{\link[sandwich]{vcovCL}} to compute clustered covariance matrix
estimators), or \code{vcov_estimation = "HC"} (which calls
\code{\link[sandwich:vcovHC]{vcovHC()}} to compute heteroskedasticity-consistent
covariance matrix estimators).}

\item{vcov_type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich:vcovHC]{vcovHC()}}
or \code{clubSandwich::vcovCR()} for details).}

\item{vcov_args}{List of named vectors, used as additional arguments that
are passed down to the \pkg{sandwich}-function specified in \code{vcov_estimation}.}

\item{transform}{Either \code{"response"} (default) or \code{"link"}. If \code{"link"}, no transformation is applied and the values are on the scale of the linear predictors. If \code{"response"}, the output is on the scale of the response variable. Thus for a default binomial model, \code{"response"} gives the predicted probabilities, and \code{"link"} makes predictions of log-odds (probabilities on logit scale).}

\item{include_random}{If \code{TRUE} (default), include all random effects in the prediction. If \code{FALSE}, don't take them into account. Can also be a formula to specify which random effects to condition on when predicting (passed to the \code{re.form} argument). If \code{include_random = TRUE} and \code{newdata} is provided, make sure to include the random effect variables in \code{newdata} as well.}

\item{bootstrap}{Should confidence intervals (CIs) be computed via bootstrapping rather than analytically. If \code{TRUE}, you can specify the number of iterations by modifying the argument \code{iter = 500} (default).}
}
\value{
The fitted values (i.e. predictions for the response).
}
\description{
Returns values predicted by a model (i.e., fitted values). The Confidence/Credible
Intervals (CI) are stored as an attribute, which one can easily extract with
\code{as.data.frame()} (see examples below).
}
\note{
Currently, this function just calls \code{stats::fitted()}, but will
be extended to other objects that don't work with \code{stats::fitted()} in
future updates.
}
\examples{
data(mtcars)
x <- lm(mpg ~ cyl + hp, data = mtcars)
predicted <- get_predicted(x)
predicted

# Get CI
attributes(predicted)$CI_low # Or CI_high
as.data.frame(predicted)
}
