% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_wordcloud.R
\name{makeWordcloud}
\alias{makeWordcloud}
\title{Word cloud based on the word-occurrence data.frame.}
\usage{
makeWordcloud(wordF, wcFormat = "png", wcminFreq = 3, wcmaxWords = Inf,
  wcRandOrder = FALSE, wcCol = RColorBrewer::brewer.pal(8, "Dark2"),
  getPlot = c(TRUE, TRUE), mwidth = 1000, mheight = 1000,
  formatType = "png")
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{wcFormat}{Output format for the word cloud (deprecated, only "png").}

\item{wcminFreq}{Minimum word frequency for words to be ploted (see \code{\link[wordcloud]{wordcloud}}).}

\item{wcmaxWords}{Maximum number of words to be ploted (see \code{\link[wordcloud]{wordcloud}}).}

\item{wcRandOrder}{Plot words in random order (see \code{\link[wordcloud]{wordcloud}}).}

\item{wcCol}{Color words (see \code{\link[wordcloud]{wordcloud}}).}

\item{getPlot}{A vector with two logical values. If \code{plots[1]==TRUE}, a word cloud is made for each document.
If \code{plots[2]==TRUE}, a word cloud is made for the combinaison of all documents.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}
}
\description{
Plot a word cloud from the word-occurrence data.frame using \code{\link[wordcloud]{wordcloud}} function.
}
\examples{
\dontrun{
makeWordcloud(wordF = myDF)
}
}
