\name{invInfMat}
\alias{invInfMat}
\title{
Invert the Information Matrix 
}
\description{
Using the eigenvalue decomposition method to invert the information matrix.
}
\usage{
invInfMat(C, N, T)
}
\arguments{
  \item{C}{
a matrix of block projector for a single stratum.
}
  \item{N}{
a matrix representation the smallest unit of block or treatment effects generated by \code{\link{makeOverDesMat}}.
}
   \item{T}{
a list of contrast matrices from  \code{\link{makeContrMat}}.
}
}
\value{
This function returns a matrix.
}
\references{
Nelder JA (1965b). "The Analysis of Randomized Experiments with Orthogonal Block Structure. II. Treatment Structure and the General Analysis of Variance." \emph{Proceedings of the Royal Society of London. Series A, Mathematical and Physical Sciences}, 283(1393), 163-178.
}
\author{
Kevin Chang
}
\examples{

m <- matrix(rnorm(10), 10, 10)

invInfMat(m, identityMat(10), identityMat(10))
     

}


