% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-os-prop-test.R
\name{infer_os_prop_test}
\alias{infer_os_prop_test}
\alias{infer_os_prop_test.default}
\alias{prop_test}
\alias{infer_os_prop_test.factor}
\title{One Sample Test of Proportion}
\usage{
infer_os_prop_test(n, prob = 0.5, alternative = c("both", "less", "greater",
  "all"), ...)

\method{infer_os_prop_test}{default}(n, prob = 0.5, alternative = c("both",
  "less", "greater", "all"), phat, ...)

\method{infer_os_prop_test}{factor}(n, prob = 0.5, alternative = c("both",
  "less", "greater", "all"), ...)
}
\arguments{
\item{n}{number of observations}

\item{prob}{hypothesised proportion}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter.}

\item{...}{other arguments}

\item{phat}{observed proportion}
}
\value{
\code{infer_os_prop_test} returns an object of class \code{"infer_os_prop_test"}.
An object of class \code{"infer_os_prop_test"} is a list containing the
following components:

\item{n}{number of observations}
\item{phat}{proportion of 1's}
\item{p}{assumed probability of success}
\item{z}{z statistic}
\item{sig}{p-value for z statistic}
\item{alt}{alternative hypothesis}
\item{obs}{observed number of 0's and 1's}
\item{exp}{expected number of 0's and 1's}
\item{deviation}{deviation of observed from expected}
\item{std}{standardized resiudals}
}
\description{
\code{infer_os_prop_test} compares proportion in one group to a
specified population proportion.
}
\section{Deprecated Function}{

\code{prop_test()} has been deprecated. Instead use \code{infer_os_prop_test()}.
}

\examples{
# use as a calculator
infer_os_prop_test(200, prob = 0.5, phat = 0.3)

# using data set
infer_os_prop_test(as.factor(hsb$female), prob = 0.5)
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{prop.test}} \code{\link[stats]{binom.test}}
}
