% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{shade_confidence_interval}
\alias{shade_confidence_interval}
\alias{shade_ci}
\title{Add information about confidence interval}
\usage{
shade_confidence_interval(endpoints, color = "mediumaquamarine",
  fill = "turquoise", ...)

shade_ci(endpoints, color = "mediumaquamarine", fill = "turquoise",
  ...)
}
\arguments{
\item{endpoints}{A 2 element vector or a 1 x 2 data frame containing the
lower and upper values to be plotted. Most useful for visualizing
conference intervals.}

\item{color}{A character or hex string specifying the color of the
end points as a vertical lines on the plot.}

\item{fill}{A character or hex string specifying the color to shade the
confidence interval. If \code{NULL} then no shading is actually done.}

\item{...}{Other arguments passed along to \{ggplot2\} functions.}
}
\value{
A list of \{ggplot2\} objects to be added to the \code{visualize()}
output.
}
\description{
\code{shade_confidence_interval()} plots confidence interval region on top of the
\code{\link[=visualize]{visualize()}} output. It should be used as \{ggplot2\} layer function (see
examples). \code{shade_ci()} is its alias.
}
\examples{
viz_plot <- mtcars \%>\%
  dplyr::mutate(am = factor(am)) \%>\%
  specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
  hypothesize(null = "independence") \%>\%
  generate(reps = 100, type = "permute") \%>\%
  calculate(stat = "t", order = c("1", "0")) \%>\%
  visualize(method = "both")

viz_plot + shade_confidence_interval(c(-1.5, 1.5))
viz_plot + shade_confidence_interval(c(-1.5, 1.5), fill = NULL)

}
\seealso{
\code{\link[=shade_p_value]{shade_p_value()}} to add information about p-value region.
}
