% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value.R
\name{p_value}
\alias{p_value}
\alias{get_pvalue}
\title{Compute the p-value for (currently only) simulation-based methods
\code{get_pvalue()} is an alias of \code{p_value}}
\usage{
p_value(x, obs_stat, direction)

get_pvalue(x, obs_stat, direction)
}
\arguments{
\item{x}{data frame of calculated statistics or containing attributes
of theoretical distribution values}

\item{obs_stat}{a numeric value or a 1x1 data frame (as extreme or more extreme than this)}

\item{direction}{a character string. Options are "less", "greater", or "two_sided".
Can also specify "left", "right", or "both".}
}
\value{
a 1x1 data frame with value between 0 and 1
}
\description{
Compute the p-value for (currently only) simulation-based methods
\code{get_pvalue()} is an alias of \code{p_value}
}
\examples{
mtcars_df <- mtcars \%>\%
    dplyr::mutate(am = factor(am))
d_hat <- mtcars_df \%>\%
    specify(mpg ~ am) \%>\%
    calculate(stat = "diff in means", order = c("1", "0"))
null_distn <- mtcars_df \%>\%
    specify(mpg ~ am) \%>\% 
    hypothesize(null = "independence") \%>\%
    generate(reps = 100) \%>\%
    calculate(stat = "diff in means", order = c("1", "0"))
null_distn \%>\% 
    p_value(obs_stat = d_hat, direction = "right")
}
