% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_aux.R
\name{YoY}
\alias{YoY}
\title{Calculates growth}
\usage{
YoY(serie, lapso, decimal = TRUE)
}
\arguments{
\item{serie}{numeric vector or series}

\item{lapso}{period separations (12 = for monthly data, 4 = quaterly data)}

\item{decimal}{Should result be in decimals? Default = TRUE. False returns percents x 100.}
}
\value{
Vector numeric
}
\description{
Year over year growth (or versus any period)
}
\note{
Vector must be in ascending order (oldest to newest). The inegi_series() function returns in that order.
}
\examples{
# Calculate inflation
\dontrun{
token <- "webservice_token"
INPC <- serie_inegi(INPC, token)
Inflation <- YoY(INPC$Valores, 12)
}
}
\author{
Eduardo Flores
}
