% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeSurrogate.R
\name{plot.TreeSurrogate}
\alias{plot.TreeSurrogate}
\title{Plot Tree Surrogate}
\usage{
\method{plot}{TreeSurrogate}(object)
}
\arguments{
\item{object}{A TreeSurrogate R6 object}
}
\value{
ggplot2 plot object
}
\description{
Plot the response for newdata of a TreeSurrogate object.
Each plot facet is one leaf node and visualises the distribution of the \eqn{\hat{y}}
from the machine learning model.
}
\examples{
if (require("randomForest")) {
# Fit a Random Forest on the Boston housing data set
data("Boston", package  = "MASS")
rf = randomForest(medv ~ ., data = Boston, ntree = 50)
# Create a model object
mod = Predictor$new(rf, data = Boston[-which(names(Boston) == "medv")]) 

# Fit a decision tree as a surrogate for the whole random forest
dt = TreeSurrogate$new(mod)

# Plot the resulting leaf nodes
plot(dt) 
}
}
\seealso{
\link{TreeSurrogate}
}
