% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalModel.R
\name{plot.LocalModel}
\alias{plot.LocalModel}
\title{Plot Local Model}
\usage{
\method{plot}{LocalModel}(object)
}
\arguments{
\item{object}{A LocalModel R6 object}
}
\value{
ggplot2 plot object
}
\description{
plot.LocalModel() plots the feature effects of a LocalModel object.
}
\examples{
if (require("randomForest")) {
# First we fit a machine learning model on the Boston housing data
data("Boston", package  = "MASS")
X = Boston[-which(names(Boston) == "medv")]
rf = randomForest(medv ~ ., data = Boston, ntree = 50)
mod = Predictor$new(rf, data = X)

# Explain the first instance of the dataset with the LocalModel method:
x.interest = X[1,]
lemon = LocalModel$new(mod, x.interest = x.interest, k = 2)
plot(lemon)
}
}
\seealso{
\link{LocalModel}
}
