test_that("Starting from state works (#225)", {
  withr::local_seed(42)

  g <- sample_gnp(10, p = 1 / 2) + sample_gnp(10, p = 1 / 2)
  hrg <- fit_hrg(g)
  hrg2 <- fit_hrg(g, hrg = hrg, start = TRUE, steps = 1)
  expect_equal(hrg2, hrg, ignore_attr = TRUE)
})

test_that("as.hclust.igraphHRG() works", {
  withr::local_seed(42)

  g <- make_graph("zachary")
  hrg <- fit_hrg(g)
  expect_snapshot({
    summary(as.hclust(hrg))
  })
})

test_that("sample_hrg() checks its argument", {
  expect_snapshot(error = TRUE, {
    sample_hrg(make_ring(10))
  })
})


test_that("hrg_tree() checks its argument", {
  expect_snapshot(error = TRUE, {
    hrg_tree(make_ring(10))
  })
})

test_that("print.igrapHRG() works", {
  withr::local_seed(42)

  small_g <- sample_gnp(10, p = 1 / 2) + sample_gnp(10, p = 1 / 2)
  small_g <- fit_hrg(small_g)

  # auto, tree because small
  expect_output(print(small_g), "- ")

  expect_output(print(small_g, type = "plain"), "->")

  # big_g <- sample_gnp(110, p = 1 / 2) + sample_gnp(110, p = 1 / 2)
  # big_g <- fit_hrg(big_g)
  big_hrg <- list(
    left = c(
      -24, 57, -68, -72, 112, -45, -142, 29, 66, -65, -93, -29, -51, -187, -113,
      -175, -91, 122, -197, -138, 158, -36, -89, -210, 188, -74, -125, -39, -41, 5,
      -66, -123, 67, -49, -59, -122, -19, -136, -92, -146, 118, -132, 144, -104,
      -161, 180, -158, 72, -196, -26, -108, 168, -218, 71, 14, 8, -207, -5, -87,
      -81, -4, 27, -183, 19, -111, -181, 117, -77, 37, -141, -20, 115, -162, -212,
      -156, 46, -95, 6, -86, 190, -35, 148, -157, 68, -44, 10, 116, -90, -176, 123,
      -11, -180, -6, -137, 111, -8, 156, -64, 134, 114, -204, 113, -143, -165, -128,
      28, -199, -194, -148, 189, -129, -54, -159, 0, -34, -185, -67, -94, 64, -178,
      -200, 45, -171, -106, -15, -61, 23, -40, -70, -55, -116, -38, 3, 39, 152,
      -193, -57, -114, 2, -18, -149, 124, -16, -14, -189, -99, -131, -85, -154, -42,
      -163, -32, 119, -103, -152, -50, -201, -28, 121, -23, -3, 110, -177, 12, 9,
      -7, 127, -219, 133, 36, -56, -173, -208, -153, -192, -73, -12, 20, -130, 1, 4,
      151, -139, -150, -63, -96, -47, 198, -205, -82, 69, -102, 131, -117, -53,
      -198, -118, -133, -145, -206, 154, -211, 163, -37, -155, -168, 11, -115, -140,
      -71, 85, -30, 159, -60, -134, 136, 143, -160, -79
    ),
    right = c(
      -172, 96, -126, 170, 132, 150, 147, -112, 97, 137, 129, 155, -151, 26, 128,
      181, -10, 213, 107, -147, 174, -76, 171, -195, 201, 74, -25, 61, -46, -121,
      59, -48, 73, 47, -80, 52, 32, 176, 58, -216, -209, 161, 157, 93, 214, 191,
      -107, 103, -31, 34, 205, 173, -169, 101, 87, -179, -33, 120, 169, -217, 195,
      33, 56, 44, -214, 18, 139, 182, -22, -105, 16, 217, -100, 31, 102, 92, -88,
      76, 22, 196, 162, -52, 185, 81, -2, 38, 172, 211, 135, 126, -203, -101, 210,
      43, 165, 108, 184, -170, 175, 212, 17, 149, 183, 89, -188, 65, 105, 125, -124,
      202, 130, 80, -166, 41, 91, -75, -190, 30, 75, 106, -119, 48, 35, 79, 177,
      215, 99, 193, 207, -215, 70, 208, -120, 51, -21, 146, 77, -144, 54, 153, 138,
      167, 145, 82, 15, 178, 21, -84, 194, 209, -27, 98, 166, -135, -164, -62, 179,
      24, -184, 200, -58, 199, -213, -98, 78, 204, 192, 49, 140, -69, -186, -17, 95,
      -167, 142, -174, -43, 88, 25, 83, -202, -83, -78, 186, -191, 40, 7, 206, 63,
      -182, 109, 203, 197, 141, -13, 42, 50, 13, 100, -9, 219, 104, 187, 62, 55,
      -127, 53, -109, 218, 60, 90, 86, 160, -110, 94, -97, 164, 216, 84
    ),
    prob = c(
      0.22866071428571427, 0, 0.966666666666667, 0, 1, 0.26666666666666666, 0.5,
      1, 0, 0.48484848484848486, 0.470588235294117641, 0.8571428571428571,
      0.477453580901856744, 0.44, 0.3076923076923077, 0, 0.5352941176470588, 0,
      0.125, 0.47156084656084657, 1, 0.6666666666666666, 0.6666666666666666, 0, 1,
      0.35714285714285715, 0.6333333333333333, 0.8, 0.2, 1, 0, 0.6428571428571429,
      0, 0.16666666666666666, 0.3333333333333333, 0, 0.7777777777777778, 0, 1, 0, 0,
      0, 0, 1, 0.7142857142857143, 1, 0.41544117647058826, 0, 0.5833333333333334, 1,
      0.9166666666666666, 1, 0.7083333333333334, 0, 1, 0.6666666666666666, 0.75, 1,
      0.5, 0.75, 0, 1, 0.25, 1, 0.5130434782608696, 0.5, 0, 0, 1,
      0.4351851851851852, 0.5609756097560976, 0, 1, 0.6153846153846154,
      0.8888888888888888, 1, 0.16666666666666666, 0, 0.5, 0, 1, 1, 1, 1, 0.375, 1,
      1, 1, 0.5, 1, 0.3888888888888889, 0.4166666666666667, 0.5625, 0, 0, 0, 1,
      0.8571428571428571, 1, 1, 0.5454545454545454, 1, 1, 1, 0.8571428571428571, 0,
      0.5806451612903226, 0.5454545454545454, 0.125, 0, 0.7272727272727273, 0.5,
      0.4444444444444444, 1, 0.461538461538461564, 0.6015037593984962, 1, 0.5, 1, 0,
      0, 0, 1, 0.5, 0.9285714285714286, 1, 0, 0.3333333333333333,
      0.47619047619047616, 0, 0.6923076923076923, 1, 0.3333333333333333, 1, 1, 1,
      0.5, 0.5961538461538461, 1, 1, 1, 1, 0, 0.372549019607843,
      0.6206896551724138, 1, 0.7407407407407407, 0.5, 1, 0.8333333333333334,
      0.6519607843137255, 0.5, 1, 0, 0.5235294117647059, 0.4375, 1, 0.875, 0.25,
      0.1, 0.181818181818181823, 1, 0.75, 0, 0, 0, 1, 0.5, 0, 0, 0.6666666666666666,
      0, 0.56, 0.75, 1, 0.25, 0.25, 0, 1, 1, 0, 1, 1, 0.14285714285714285, 0.8, 0.4,
      0.6326530612244898, 0, 0.5714285714285714, 0.6, 1, 0, 1, 0.5,
      0.4387755102040816, 0.6, 1, 1, 0.13333333333333333, 0.6428571428571429, 1, 1,
      1, 1, 0.7407407407407407, 0.3, 0, 0.5454545454545454, 0.3333333333333333,
      0.4819277108433735, 0, 0.16666666666666666, 1, 0.625, 0, 0, 1,
      0.090909090909090912, 0.3333333333333333
    ),
    edges = c(
      2561, 0, 29, 0, 1, 4, 1, 3, 0, 16, 8, 6, 180, 22, 4, 0, 364, 0, 1, 713, 1, 4,
      6, 0, 1, 5, 19, 12, 2, 11, 0, 18, 0, 2, 2, 0, 7, 0, 14, 0, 0, 0, 0, 3, 10, 1,
      226, 0, 21, 15, 11, 1, 17, 0, 1, 4, 3, 2, 1, 9, 0, 1, 1, 1, 118, 2, 0, 0, 5,
      47, 46, 0, 4, 8, 16, 1, 1, 0, 1, 0, 5, 2, 3, 1, 3, 1, 1, 2, 4, 1, 14, 10, 9,
      0, 0, 0, 1, 12, 1, 1, 6, 1, 6, 2, 12, 0, 18, 6, 3, 0, 16, 1, 16, 1, 6, 80, 16,
      3, 1, 0, 0, 0, 13, 1, 13, 4, 0, 2, 10, 0, 18, 4, 1, 1, 2, 2, 2, 62, 1, 2, 11,
      1, 0, 19, 18, 2, 20, 6, 10, 5, 133, 8, 1, 0, 89, 14, 2, 14, 2, 1, 6, 1, 15, 0,
      0, 0, 1, 2, 0, 0, 28, 0, 14, 3, 3, 4, 4, 0, 5, 1, 0, 4, 4, 1, 8, 2, 31, 0, 16,
      9, 1, 0, 1, 5, 258, 3, 7, 4, 4, 9, 1, 2, 1, 10, 20, 3, 0, 84, 1, 40, 0, 2, 1,
      10, 0, 0, 1, 1, 1
    ),
    vertices = c(
      220, 2, 11, 3, 2, 16, 3, 4, 2, 34, 18, 8, 42, 51, 14, 5, 54, 2, 9, 82, 2, 5,
      10, 140, 2, 15, 17, 16, 7, 12, 6, 16, 2, 13, 5, 3, 10, 4, 15, 6, 5, 6, 2, 4,
      15, 2, 49, 2, 12, 16, 13, 2, 14, 2, 2, 7, 4, 3, 3, 8, 4, 2, 5, 2, 33, 5, 2, 6,
      6, 21, 83, 2, 4, 14, 19, 2, 5, 2, 3, 2, 6, 3, 4, 2, 6, 2, 2, 3, 9, 2, 20, 14,
      17, 6, 2, 5, 2, 9, 2, 2, 12, 2, 7, 3, 9, 2, 32, 12, 11, 2, 23, 3, 13, 2, 14,
      26, 10, 7, 2, 3, 11, 2, 14, 3, 15, 5, 2, 7, 22, 5, 27, 5, 4, 2, 3, 3, 5, 54,
      2, 3, 12, 2, 6, 52, 30, 3, 28, 8, 11, 7, 29, 17, 2, 10, 27, 18, 3, 17, 9, 11,
      14, 2, 12, 10, 2, 4, 2, 5, 2, 7, 13, 80, 26, 4, 4, 8, 10, 2, 6, 2, 4, 5, 4, 8,
      7, 6, 50, 2, 29, 8, 2, 3, 2, 11, 56, 6, 8, 5, 31, 9, 2, 3, 2, 11, 28, 7, 2,
      25, 4, 84, 2, 13, 2, 10, 3, 3, 2, 12, 4
    )
  ) |>
    structure(class = "igraphHRG")

  # auto, plain because not small
  expect_output(print(big_hrg), "->")

  expect_output(print(big_hrg, type = "tree"), "- ")
})
