% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make.R
\name{make_full_citation_graph}
\alias{full_citation_graph}
\alias{graph.full.citation}
\alias{make_full_citation_graph}
\title{Create a complete (full) citation graph}
\usage{
make_full_citation_graph(n, directed = TRUE)

full_citation_graph(...)
}
\arguments{
\item{n}{The number of vertices.}

\item{directed}{Whether to create a directed graph.}

\item{...}{Passed to \code{make_full_citation_graph}.}
}
\value{
An igraph graph.
}
\description{
\code{make_full_citation_graph} creates a full citation graph. This is a
directed graph, where every \code{i->j} edge is present if and only if
\eqn{j<i}. If \code{directed=FALSE} then the graph is just a full graph.
}
\examples{
str(make_full_citation_graph(10))
}
\seealso{
Other determimistic constructors: \code{\link{atlas}},
  \code{\link{graph.atlas}},
  \code{\link{graph_from_atlas}};
  \code{\link{chordal_ring}},
  \code{\link{graph.extended.chordal.ring}},
  \code{\link{make_chordal_ring}};
  \code{\link{directed_graph}}, \code{\link{graph}},
  \code{\link{graph.famous}},
  \code{\link{make_directed_graph}},
  \code{\link{make_graph}},
  \code{\link{make_undirected_graph}},
  \code{\link{undirected_graph}};
  \code{\link{empty_graph}}, \code{\link{graph.empty}},
  \code{\link{make_empty_graph}};
  \code{\link{from_edgelist}},
  \code{\link{graph.edgelist}},
  \code{\link{graph_from_edgelist}};
  \code{\link{from_literal}}, \code{\link{graph.formula}},
  \code{\link{graph_from_literal}};
  \code{\link{full_graph}}, \code{\link{graph.full}},
  \code{\link{make_full_graph}};
  \code{\link{graph.lattice}}, \code{\link{lattice}},
  \code{\link{make_lattice}}; \code{\link{graph.ring}},
  \code{\link{make_ring}}, \code{\link{ring}};
  \code{\link{graph.star}}, \code{\link{make_star}},
  \code{\link{star}}; \code{\link{graph.tree}},
  \code{\link{make_tree}}, \code{\link{tree}}
}

