% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifo.R
\name{ifo_climate}
\alias{ifo_climate}
\title{Return ifo climate data}
\usage{
ifo_climate(type = c("import", "export", "world", "euro"))
}
\arguments{
\item{type}{\code{character(1)} Defaults to \code{"import"}. One of:
\itemize{
\item \code{"import"}: returns the ifo import climate.
\item \code{"export"}: returns the ifo export climate.
\item \code{"world"}: returns the ifo world economic climate.
\item \code{"euro"}: returns the ifo world economic climate for the euro zone.
}}
}
\value{
A \code{data.frame()} containing the monthly ifo climate time series.
}
\description{
Return ifo climate data
}
\examples{
\donttest{
ifo_climate("import")
}
}
\references{
Grimme C, Lehmann R, Nöller M (2018).
\dQuote{Das ifo Importklima -- ein erster Frühindikator für die Prognose der deutschen Importe.}
\emph{ifo Schnelldienst}, \bold{71}(12), 27--32.

Grimme, Christian, Lehmann, Robert, Nöller, Marvin (2021).
\dQuote{Forecasting imports with information from abroad.}
\emph{Economic Modelling}, \bold{98}, 109--117.
}
