% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve_ode}
\alias{solve_ode}
\title{A Simple Wrapper for lsoda}
\usage{
solve_ode(
  model = NULL,
  inits = NULL,
  params = NULL,
  times = NULL,
  as.data.frame = TRUE,
  ...
)
}
\arguments{
\item{model}{A model formatted as required by \code{\link[deSolve]{lsoda}}, see \code{\link[idmodelr]{SI_ode}} for an example.}

\item{inits}{The initial state (states) of the model. Can either be supplied as a named vector or as a matrix with each
row representing a parameter.}

\item{params}{A named vector or matrix of parameters. The matrix must have a row for each parameter and if \code{inits} is specified
as a matrix then \code{params} must have the same number of columns}

\item{times}{A numeric vector of the times for which explicit model estimates are required, this does not effect
the timestep used by the solver}

\item{as.data.frame}{A logical (defaults to \code{TRUE}) indicating if the results should be returned as a data frame.}

\item{...}{Additional arguments to pass to \code{\link[deSolve]{lsoda}}.}
}
\value{
A dataframe or lsoda object containing a single or multiple model trajectories
}
\description{
This function acts as a simple wrapper for lsoda, allowing for multiple parameter sets and
initial conditions. It also allows \code{\link[deSolve]{lsoda}} to be used within the idmodelr framework.
}
\examples{
## Intialise
N = 100000
I_0 = 1
S_0 = N - I_0
R_0 = 1.1
beta = R_0

##Time for model to run over
tbegin = 0
tend = 50
times <- seq(tbegin, tend, 1)

##Vectorise input
parameters <- as.matrix(c(beta = beta))
inits <- as.matrix(c(S = S_0, I = I_0))

solve_ode(model = SI_ode, inits, parameters, times, as.data.frame = TRUE)
}
\seealso{
\code{\link[deSolve]{lsoda}} \code{\link[idmodelr]{SI_ode}}
}
