% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIdiograms.R
\name{plotIdiograms}
\alias{plotIdiograms}
\title{Function to plot idiograms of karyotypes with centromere}
\usage{
plotIdiograms(dfChrSize, dfMarkColor, dfMarkPos, dfCenMarks,
  MarkDistanceType = "beg", orderBySize = TRUE, centromereSize = 1,
  chrWidth = 1.5, chrSpacing = 1.5, chrColor = "gray",
  cenColor = "gray", roundness = 4, dotRoundCorr = 1.5,
  karHeight = 1.2, karSpacing = 1.6, reduDistKar = TRUE,
  reduDistKarTol = 9, chrId = "original", distTextChr = 0.3,
  indexIdTextSize = 0.4, OTUTextSize = 0.6, legend = "inline",
  markLabelSize = 0.4, markLabelSpacer = 2, chrIndex = TRUE,
  nameChrIndexPos = 2, karIndex = TRUE, karIndexPos = 0.5,
  morpho = TRUE, addOTUName = TRUE, revOTUs = FALSE, ruler = TRUE,
  rulerPos = -0.5, rulerPosMod = 0, ruler.tck = -0.004,
  rulerNumberPos = 0.2, rulerNumberSize = 0.4, xlimLeftMod = 1,
  xlimRightMod = 10, ylimBotMod = 0.02, ...)
}
\arguments{
\item{dfChrSize}{dataframe with columns: OTU (optional), chrName,
shortArmSize, longArmSize}

\item{dfMarkColor}{dataframe specifying colors and style for marks (sites);
cols: markName, markColor, style: square or dots (default=square)}

\item{dfMarkPos}{dataframe of marks (sites): cols: OTU (opt) chrName,
markName (name of site), markArm, markDistCen, markSize; column markArm:
use p for short and q for long; col markDistCen: use distance from
centromere to mark}

\item{dfCenMarks}{dataframe, specific for centromeric marks. cols: chrName
and markName}

\item{MarkDistanceType}{character, if cen = the distance you provided is to
the center of the mark, if beg = the distance you provided is to the
beginning of the mark}

\item{orderBySize}{logical value, when TRUE, sorts chromosomes by total
length from the largest to the smallest}

\item{centromereSize}{numeric, this establishes the apparent size of cen in
the plot in \eqn{\mu}m}

\item{chrWidth}{numeric, chromosome width}

\item{chrSpacing}{numeric, horizontal spacing among chromosomes}

\item{chrColor}{character, main color for chromosomes}

\item{cenColor}{character, color for centromeres}

\item{roundness}{numeric, shape of vertices of chromosomes and square marks,
higher values more squared}

\item{dotRoundCorr}{numeric, correct roundness of dots. When style of sites =
dots, an increase in this, makes the horizontal radius of the dot smaller}

\item{karHeight}{numeric, vertical size of karyotypes}

\item{karSpacing}{numeric, proportional to karHeight for spacing of
karyotypes, y axis, if overlap, increase}

\item{reduDistKar}{boolean, reduce distance among karyotypes FALSE = equally
sized karyotypes or TRUE= equally spaced karyotypes}

\item{reduDistKarTol}{numeric, depends on reduDistKar=TRUE, if zero your
karyotypes will have no distance among them, use 1 to 11, if overlap,
increase this and karSpacing}

\item{chrId}{character, print name of chromosme, "original" uses the original
name in OTU column of dfChrSize, "simple" (just 1 to ...) or "" (none).}

\item{distTextChr}{numeric, distance from name of chromosome to chromosome,
also affects vertical separation of indices}

\item{indexIdTextSize}{numeric, font size of chr. and kar. indices and
chromosome name}

\item{OTUTextSize}{numeric, font size of OTU name (species)}

\item{legend}{character, "" for no legend; "inline" prints labels near
chromosomes; "aside" prints legend to the right of karyotypes}

\item{markLabelSize}{numeric, only if legend != "", size of the text of
labels of marks (legend)}

\item{markLabelSpacer}{numeric, only if legend="aside", space from the
rightmost chr. to legend}

\item{chrIndex}{logical, add arm ratio and centromeric index}

\item{nameChrIndexPos}{numeric, modify position of name of chr. indices}

\item{karIndex}{logical, add karyotype indices A (intrachromosomal -
centromere pos.) and A2 (interchromosomal asymmetry, variation among
chromosome sizes)}

\item{karIndexPos}{numeric, move karyotype index}

\item{morpho}{boolean, if TRUE prints the Guerra and Levan classif of cen.
position. see ?armRatioCI}

\item{addOTUName}{boolean, if TRUE adds OTU (species) name to karyotype}

\item{revOTUs}{boolean, The order of species is the one in the main
dataframe, use TRUE to reverse}

\item{ruler}{boolean, display ruler to the left of karyotype, when FALSE no ruler}

\item{rulerPos}{numeric, absolute position of ruler, corresponds to pos
argument of axis R plot}

\item{rulerPosMod}{numeric, modify position of ruler, corresponds to line
argument of axis R plot}

\item{ruler.tck}{numeric, tick size of ruler, corresponds to tck argument of
axis R plot}

\item{rulerNumberPos}{numeric, modify position of numbers of ruler}

\item{rulerNumberSize}{numeric, size of number's font in ruler}

\item{xlimLeftMod}{numeric, modifies xlim left parameter of plot}

\item{xlimRightMod}{numeric, xlim modification by adding space to the right
of idiograms}

\item{ylimBotMod}{numeric, modify ylim bottom parameter of plot}

\item{...}{accepts other arguments for the plot, such as, asp}
}
\value{
plot
}
\description{
This function reads a dataframe  with columns: \code{chrName}
\code{shortArmSize} and \code{longArmSize} and plots as idiograms. If more
than one species, a column named \code{OTU} is needed. For Mb use preferably
\code{plotIdiogramsHolo}

Optionally, it reads another dataframe with the position of
marks (sites) \code{dfMarkPos}, in which case a dataframe for mark color is
necessary \code{dfMarkColor}
}
\examples{
data(dfOfChrSize)
plotIdiograms(dfOfChrSize)
}
\seealso{
plotIdiogramsHolo

asymmetry

armRatioCI
}
\keyword{chromosome}
\keyword{dataframe}
