% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{id_plot_irf}
\alias{id_plot_irf}
\title{Generate Impulse Response Functions for Covariates}
\usage{
id_plot_irf(object, cov_name = NULL, label_high = "Liberal",
  label_low = "Conservative", pred_outcome = NULL, recalc_vals = F,
  include = NULL, time_calc = 10, time_label = "Time Points",
  line_type = 2, line_width = 1, line_alpha = 1,
  line_color = "red", ci_color = "black", ci_alpha = 0.5,
  use_ci = TRUE, high_quantile = 0.95, low_quantile = 0.05,
  calc_varying = T)
}
\arguments{
\item{object}{A fitted \code{idealstan} object}

\item{cov_name}{The name of the covariate to plot. Leave blank to select 
from a list of available covariates}

\item{label_high}{The character label for the upper end of the latent scale}

\item{label_low}{The character label for the lower end of the latent scale}

\item{pred_outcome}{For discrete models with more than 2 categories, 
or binary models with missing data, which outcome to predict. This should 
be a character value that matches what the outcome was coded as in the data
passed to \code{\link{id_make}}.}

\item{recalc_vals}{Whether to combine two variables into one through addition before
computing IRFs. If \code{TRUE}, two names of parameters should be passed to 
\code{cov_name} or selected from the dialog list}

\item{include}{A list of character names of person or group IDs for which to
calculate IRFs}

\item{time_calc}{The maximum number of time points over which to calculate the
IRF}

\item{time_label}{Character string specifying the type of time points (default is just
\code{"Time Points"})}

\item{line_type}{The line type of the IRF line (see \code{ggplot2} documentation)}

\item{line_width}{The line width of the IRF line (see \code{ggplot2} documentation)}

\item{line_alpha}{The line alpha (transparency) of the IRF line (see \code{ggplot2} documentation)}

\item{line_color}{The color of the IRF line (see \code{ggplot2} documentation)}

\item{ci_color}{The color of the IRF credible interval (see \code{ggplot2} documentation)}

\item{ci_alpha}{The alpha of the IRF credible interval (see \code{ggplot2} documentation)}

\item{use_ci}{Whether or not to plot a credible interval around the lines}

\item{high_quantile}{The upper limit of the posterior density to use for 
calculating credible intervals}

\item{low_quantile}{The lower limit of the posterior density to use for
calculating credible intervals}

\item{calc_varying}{if \code{TRUE}, will calculate marginal effects of the
covariates on each end of the latent scale (see vignette for more information)}
}
\value{
a \code{ggplot2} object that can be further customized if necessary
}
\description{
This function will generate an impulse response function (IRF)
for a given covariate. The IRF shows the marginal impact of a 1-unit
change in the covariate on a person's ideal point over time. To use 
this function, the \code{vary_ideal_pts} option in 
\code{\link{id_estimate}} must have received the \code{'AR1'} option
as IRFs are only available for the AR(1) auto-regressive model.
}
