% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doROCcurveMRMC.R
\name{doROCavg}
\alias{doROCavg}
\title{Empirically average over multiple empirical ROC curves}
\usage{
doROCavg(ROC, direction = "SeSp")
}
\arguments{
\item{ROC}{list of ROC curves. Each element of the list
is a data frame with pairs of (fpf, tpf) operating points.}

\item{direction}{the direction over which to average
\itemize{
  \item{\code{SeSp} (default) The ROC curves are averaged diagonally.
    Average Se+Sp of all the input ROC curves
    for every possible Se-Sp.}
  \item{\code{Se} The ROC curves are averaged vertically.
    Average the sensitivity of all the input ROC curves
    for every possible specificity.}
  \item{\code{Sp} The ROC curves are averaged horizontally.
    Average the specificity of all the input ROC curves
    for every possible specificity.}
}}
}
\value{
data frame of an ROC curve
\itemize{
  \item{\code{fpf} False-positive fractions (1-specificity)}
  \item{\code{tpf} True-positive fractions (sensitivity)}
}
}
\description{
Empirically average over multiple empirical ROC curves
}
