% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_ieg.R
\name{sample_correlated_ieg_pair}
\alias{sample_correlated_ieg_pair}
\alias{sample_correlated_rdpg_pair}
\title{Sample graphs from edge probability matrix and correlation matrix}
\usage{
sample_correlated_ieg_pair(
  n,
  p_mat,
  c_mat,
  ncore = n,
  directed = FALSE,
  loops = FALSE,
  permutation = 1:n
)

sample_correlated_rdpg_pair(X, corr, ncore = nrow(X), ...)
}
\arguments{
\item{n}{An integer. Number of total vertices for the sampled graphs.}

\item{p_mat}{An \code{n-by-n} matrix. Edge probability matrix, each entry
should be in the open (0,1) interval.}

\item{c_mat}{An \code{n-by-n} matrix. The target Pearson correlation matrix,
each entry should be in the open (0,1) interval.}

\item{ncore}{An integer. Number of core vertices.}

\item{directed}{Logical scalar, whether to generate directed graphs.}

\item{loops}{Logical scalar, whether self-loops are allowed in the graph.}

\item{permutation}{A numeric vector,permute second graph.}

\item{X}{A matrix. Dot products matrix, each entry must be in open (0,1)
interval.}

\item{corr}{A number. The target Pearson correlation between the adjacency
matrices of the generated graphs. It must be in open (0,1) interval.}

\item{...}{Passed to \code{sample_correlated_ieg_pair}.}
}
\value{
\code{sample_correlated_ieg_pair} returns two igraph objects named
  \code{graph1} and \code{graph2}. If sample two graphs with junk vertices,
  the first \code{ncore} vertices are core vertices and the rest are junk
  vertices.

\code{sample_correlated_rdpg_pair} returns two igraph objects named
\code{graph1} and \code{graph2} that are sampled from random dot product
graphs model. If sample two graphs with junk vertices, the first
\code{ncore} vertices are core vertices and the rest are junk vertices.
}
\description{
Sample a pair of graphs with specified edge probability and
  correlation between each pair of vertices.
}
\examples{
n <- 50
p_mat <- matrix(runif(n^2),n)
c_mat <- matrix(runif(n^2),n)
sample_correlated_ieg_pair(n,p_mat,c_mat,ncore=40)

## sample a pair of igraph objects from random dot
## product graphs model with dimension 3 and scale 8
n <- 50
xdim <- 3
scale <- 8
X <- matrix(rgamma(n*(xdim+1),scale,1),n,xdim+1)
X <- X/rowSums(X)
X <- X[,1:xdim]
sample_correlated_rdpg_pair(X,corr=0.5,ncore=40)

}
\references{
S. Young and E. Scheinerman (2007), \emph{Random Dot Product
  Graph Models for Social Networks}. Proceedings of the 5th International
  Conference on Algorithms and Models for the Web-graph, pages 138-149.

F. Fang and D. Sussman and V. Lyzinski (2018), \emph{Tractable
  Graph Matching via Soft Seeding}. \url{https://arxiv.org/abs/1807.09299}.
}
\seealso{
\code{\link{sample_correlated_gnp_pair}},
  \code{\link{sample_correlated_sbm_pair}}
}
