% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_gnp.R
\name{sample_correlated_gnp_pair}
\alias{sample_correlated_gnp_pair}
\alias{sample_correlated_gnp_pair_w_junk}
\title{Sample correlated G(n,p) random graphs}
\usage{
sample_correlated_gnp_pair(n, corr, p, permutation = 1:n, ...)

sample_correlated_gnp_pair_w_junk(
  n,
  corr,
  p,
  ncore = n,
  permutation = 1:n,
  ...
)
}
\arguments{
\item{n}{An integer. Number of total vertices for the sampled graphs.}

\item{corr}{A number. The target Pearson correlation between the adjacency matrices
of the generated graphs. It must be in open (0,1) interval.}

\item{p}{A number. Edge probability between two vertices. It must be in open
(0,1) interval.}

\item{permutation}{A numeric vector,permute second graph.}

\item{...}{Passed to \code{sample_correlated_gnp_pair} and \code{sample_correlated_gnp_pair_w_junk}.}

\item{ncore}{An integer. Number of core vertices.}
}
\value{
\code{sample_correlated_gnp_pair} returns a list of two 'igraph' object, named
\code{graph1} and \code{graph2}, which are two graphs whose adjacency matrix entries
correlated with \code{rho}.

\code{sample_correlated_gnp_pair_w_junk} returns a list of two 'igraph' object, named
\code{graph1} and \code{graph2}, which are two graphs whose adjacency matrix entries
correlated with \code{rho} and with first ncore vertices being core vertices and the rest being
junk vertices.
}
\description{
Sample a pair of correlated G(n,p) random graphs with correlation between
two graphs being \code{rho} and edge probability being \code{p}.
}
\examples{
sample_correlated_gnp_pair(50, 0.3, 0.5)
sample_correlated_gnp_pair_w_junk(50, 0.3, 0.5, 40)


}
