% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F029.top.markers.R
\name{top.markers}
\alias{top.markers}
\title{Choose top marker genes}
\usage{
top.markers(
  x = NULL,
  topde = 10,
  min.base.mean = 0.2,
  filt.ambig = TRUE,
  cluster = 0
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{topde}{Number of top differentially expressed genes to be choosen from each cluster, default = 10.}

\item{min.base.mean}{Minimum base mean of the genes to be chosen, default = 0.5.}

\item{filt.ambig}{Filter markers that are seen for more than one cluster, default = TRUE.}

\item{cluster}{Choose a cluster to find markers for. If 0, it would find markers for all clusters, , default = 0.}
}
\value{
A set of gene names
}
\description{
This function takes the marker genes info if chooses marker gene names for plots.
}
\examples{
marker.genes <- findMarkers(demo.obj,fold.change = 2,padjval = 0.1,uniq = TRUE)
top.markers(marker.genes, topde = 10, min.base.mean = 0.8)
}
